/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.item.attachments;

import de.cas_ual_ty.guncus.item.AttachmentItem;
import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.item.attachments.Accessory;
import de.cas_ual_ty.guncus.item.attachments.Ammo;
import de.cas_ual_ty.guncus.item.attachments.Auxiliary;
import de.cas_ual_ty.guncus.item.attachments.Barrel;
import de.cas_ual_ty.guncus.item.attachments.Magazine;
import de.cas_ual_ty.guncus.item.attachments.Optic;
import de.cas_ual_ty.guncus.item.attachments.Paint;
import de.cas_ual_ty.guncus.item.attachments.Underbarrel;
import java.util.function.Consumer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum EnumAttachmentType {
    OPTIC("optic", 0, 1, 0, Optic.DEFAULT),
    ACCESSORY("accessory", 1, 2, 2, Accessory.DEFAULT),
    BARREL("barrel", 2, 0, 0, Barrel.DEFAULT),
    UNDERBARREL("underbarrel", 3, 0, 1, Underbarrel.DEFAULT),
    AUXILIARY("auxiliary", 4, 0, 2, Auxiliary.DEFAULT),
    AMMO("ammo", 5, 2, 0, Ammo.DEFAULT),
    MAGAZINE("magazine", 6, 1, 2, Magazine.DEFAULT),
    PAINT("paint", 7, 2, 1, Paint.DEFAULT);

    public static final EnumAttachmentType[] VALUES;
    public static final EnumAttachmentType[] RENDER_ORDER;
    public static final int LENGTH;
    private final String key;
    private final int slot;
    private final int x;
    private final int y;
    private final AttachmentItem _default;

    private EnumAttachmentType(String key, int slot, int x, int y, AttachmentItem _default) {
        this.key = key;
        this.slot = slot;
        this.x = x;
        this.y = y;
        this._default = _default;
    }

    public String getKey() {
        return this.key;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public AttachmentItem getDefault() {
        return this._default;
    }

    public String getDefaultResource() {
        return this.getKey() + "_default";
    }

    public String getTranslationKey() {
        return "local.guncus." + this.getKey();
    }

    public IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public static EnumAttachmentType getSlot(int slot) {
        return VALUES[slot];
    }

    public static IFormattableTextComponent getDisplayName(int slot) {
        return EnumAttachmentType.getSlot(slot).getDisplayName();
    }

    public static void callForAll(GunItem gun, Consumer<AttachmentItem[]> consumer) {
        EnumAttachmentType.callForAll(gun.getAttachments(), consumer);
    }

    public static void callForAll(AttachmentItem[][] attachments, Consumer<AttachmentItem[]> consumer) {
        EnumAttachmentType.recCallForAll(consumer, attachments, new AttachmentItem[LENGTH], 0);
    }

    private static void recCallForAll(Consumer<AttachmentItem[]> consumer, AttachmentItem[][] attachments, AttachmentItem[] current, int slot) {
        if (slot < LENGTH) {
            for (int i = 0; i < attachments[slot].length; ++i) {
                current[slot] = attachments[slot][i];
                EnumAttachmentType.recCallForAll(consumer, attachments, current, slot + 1);
            }
        } else {
            consumer.accept(current);
        }
    }

    static {
        VALUES = EnumAttachmentType.values();
        RENDER_ORDER = new EnumAttachmentType[]{PAINT, MAGAZINE, AMMO, AUXILIARY, UNDERBARREL, BARREL, ACCESSORY, OPTIC};
        LENGTH = VALUES.length;
    }
}

