/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.item.attachments;

import de.cas_ual_ty.guncus.item.AttachmentItem;
import de.cas_ual_ty.guncus.item.MakerItem;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Optic
extends AttachmentItem {
    public static final List<MakerItem> MAKER_OPTICS_LIST = new ArrayList<MakerItem>();
    public static final Optic DEFAULT = (Optic)new Optic().setNoOverlay().setRegistryName("guncus", "optic_default");
    protected Supplier<ResourceLocation> overlay;
    protected EnumOpticType opticType;

    public Optic(Item.Properties properties, ItemStack ... materials) {
        super(properties, materials);
        this.setExtraZoom(1.0f);
        this.overlay = () -> new ResourceLocation(this.getRegistryName().func_110624_b(), "textures/gui/sights/" + this.getRegistryName().func_110623_a() + ".png");
        this.opticType = EnumOpticType.NORMAL;
        if (this.craftAmount > 0 && materials.length > 0) {
            MAKER_OPTICS_LIST.add(this);
        }
    }

    protected Optic() {
        this(new Item.Properties(), new ItemStack[0]);
    }

    @Override
    public EnumAttachmentType getType() {
        return EnumAttachmentType.OPTIC;
    }

    public boolean isCompatibleWithMagnifiers() {
        return this.getZoom() <= 4.0f;
    }

    public boolean isCompatibleWithExtraZoom() {
        return !this.isCompatibleWithMagnifiers();
    }

    public boolean canAim() {
        return true;
    }

    public ResourceLocation getOverlay() {
        return this.overlay.get();
    }

    public boolean getIsClosedScope() {
        return this.getZoom() >= 6.0f;
    }

    public float getZoom() {
        return this.getExtraZoom();
    }

    public EnumOpticType getOpticType() {
        return this.opticType;
    }

    public Optic setNoOverlay() {
        this.overlay = () -> null;
        return this;
    }

    public Optic setOverlay(Supplier<ResourceLocation> overlay) {
        if (overlay != null) {
            this.overlay = overlay;
        }
        return this;
    }

    public Optic setOpticType(EnumOpticType opticType) {
        this.opticType = opticType;
        return this;
    }

    @Override
    public IFormattableTextComponent getInformationString() {
        return super.getInformationString().func_230529_a_((ITextComponent)this.getInformationStringSuffix());
    }

    public IFormattableTextComponent getInformationStringSuffix() {
        return new StringTextComponent(this.isDefault() ? "" : " (" + this.getZoom() + ")").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.WHITE));
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent("" + this.getZoom()).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("local.guncus.zoom")).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.WHITE)));
    }

    public static enum EnumOpticType {
        NORMAL,
        NIGHT_VISION,
        THERMAL;

    }
}

