/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.itemgroup;

import de.cas_ual_ty.guncus.GunCus;
import de.cas_ual_ty.guncus.item.AttachmentItem;
import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.item.attachments.Ammo;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.itemgroup.ShuffleItemGroup;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class GunItemGroup
extends ShuffleItemGroup {
    protected final GunItem gun;
    protected List<ItemStack> allVariants;

    public GunItemGroup(String label, GunItem gun) {
        super(label);
        this.gun = gun;
        this.field_151245_t = new ItemStack((IItemProvider)this.gun);
        this.allVariants = null;
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        super.func_78018_a(items);
        items.add((Object)new ItemStack((IItemProvider)this.gun));
        items.add((Object)new ItemStack((IItemProvider)this.gun.getBaseBullet()));
        for (AttachmentItem attachment : this.gun.getAttachments()[EnumAttachmentType.AMMO.getSlot()]) {
            Ammo ammo = (Ammo)attachment;
            if (ammo.isDefault() || ammo.getReplacementBullet() == null || ammo.getReplacementBullet() == this.gun.getBaseBullet()) continue;
            items.add((Object)new ItemStack((IItemProvider)ammo.getReplacementBullet()));
        }
        AttachmentItem[] attachmentItemArray = this.gun.getAttachments();
        int n = attachmentItemArray.length;
        for (int i = 0; i < n; ++i) {
            AttachmentItem attachments;
            for (AttachmentItem attachment : attachments = attachmentItemArray[i]) {
                if (attachment.isDefault()) continue;
                items.add((Object)new ItemStack((IItemProvider)attachment));
            }
        }
        if (GunCus.FULL_CREATIVE_TABS && this.allVariants != null) {
            GunCusUtility.addAllToNonNullList(items, this.allVariants);
        }
    }

    @Override
    public void fillShuffleList(NonNullList<ItemStack> list) {
        if (this.allVariants != null) {
            GunCusUtility.addAllToNonNullList(list, this.allVariants);
        }
    }

    public ITextComponent func_242392_c() {
        return this.gun.func_200296_o();
    }

    public void init() {
        this.allVariants = GunCusUtility.createAllVariants(this.gun);
    }
}

