/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.network;

import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ShootMessage {
    public boolean aiming;
    public int inaccuracy;
    public int handsInt;

    public ShootMessage(boolean aiming, int inaccuracy, int handsInt) {
        this.aiming = aiming;
        this.inaccuracy = inaccuracy;
        this.handsInt = handsInt;
    }

    public static void encode(ShootMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.aiming);
        buf.writeInt(msg.inaccuracy);
        buf.writeInt(msg.handsInt);
    }

    public static ShootMessage decode(PacketBuffer buf) {
        return new ShootMessage(buf.readBoolean(), buf.readInt(), buf.readInt());
    }

    public static void handle(ShootMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player != null) {
                GunItem.tryShoot((PlayerEntity)player, msg.aiming, msg.inaccuracy, GunCusUtility.intToHands(msg.handsInt));
            }
        });
        context.setPacketHandled(true);
    }
}

