/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.util;

import com.google.common.collect.ImmutableSet;
import de.cas_ual_ty.guncus.item.AttachmentItem;
import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class GunCusUtility {
    private static Method blockStatesInjector = ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class});
    private static Field nonNullListElements = ObfuscationReflectionHelper.findField(NonNullList.class, (String)"field_191198_a");
    public static final Hand[] HANDS;

    public static Hand[] intToHands(int handsInt) {
        if (handsInt == 1) {
            return new Hand[]{Hand.MAIN_HAND};
        }
        if (handsInt == 2) {
            return new Hand[]{Hand.OFF_HAND};
        }
        if (handsInt == 3) {
            return new Hand[]{Hand.MAIN_HAND, Hand.OFF_HAND};
        }
        return new Hand[0];
    }

    public static AxisAlignedBB aabbFromVec3ds(Vector3d vec1, Vector3d vec2) {
        return new AxisAlignedBB(Math.min(vec1.field_72450_a, vec2.field_72450_a), Math.min(vec1.field_72448_b, vec2.field_72448_b), Math.min(vec1.field_72449_c, vec2.field_72449_c), Math.max(vec1.field_72450_a, vec2.field_72450_a), Math.max(vec1.field_72448_b, vec2.field_72448_b), Math.max(vec1.field_72449_c, vec2.field_72449_c));
    }

    public static ArrayList<ItemStack> createAllVariants(GunItem gun) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(gun.getVariantsAmt());
        EnumAttachmentType.callForAll(gun, attachments -> itemStacks.add(gun.createVariant((AttachmentItem[])attachments)));
        return itemStacks;
    }

    public static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.func_176194_O().func_177619_a());
    }

    public static void fixPOITypeBlockStates(PointOfInterestType poiType) {
        try {
            blockStatesInjector.invoke(null, poiType);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static <E> void addAllToNonNullList(NonNullList<E> list, List<E> elements) {
        try {
            Object arrayList = nonNullListElements.get(list);
            if (arrayList instanceof ArrayList) {
                ((ArrayList)arrayList).addAll(elements);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        list.addAll(elements);
    }

    static {
        nonNullListElements.setAccessible(true);
        HANDS = Hand.values();
    }
}

