/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.event.IndicatiaEventHandler;
import com.stevekung.indicatia.hud.InfoUtils;
import com.stevekung.indicatia.utils.AFKMode;
import com.stevekung.stevekungslib.utils.CommonUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import com.stevekung.stevekungslib.utils.client.command.ClientCommands;
import com.stevekung.stevekungslib.utils.client.command.IClientCommand;
import com.stevekung.stevekungslib.utils.client.command.IClientSuggestionProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.util.StringUtils;

public class AFKCommand
implements IClientCommand {
    public void register(CommandDispatcher<IClientSuggestionProvider> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommands.literal((String)"afk").then(((LiteralArgumentBuilder)ClientCommands.literal((String)"start").executes(requirement -> AFKCommand.startAFK((IClientSuggestionProvider)requirement.getSource(), null))).then(ClientCommands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(requirement -> AFKCommand.startAFK((IClientSuggestionProvider)requirement.getSource(), StringArgumentType.getString((CommandContext)requirement, (String)"reason")))))).then(ClientCommands.literal((String)"stop").executes(requirement -> AFKCommand.stopAFK((IClientSuggestionProvider)requirement.getSource())))).then(ClientCommands.literal((String)"change_reason").then(ClientCommands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(requirement -> AFKCommand.setReason((IClientSuggestionProvider)requirement.getSource(), StringArgumentType.getString((CommandContext)requirement, (String)"reason")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommands.literal((String)"mode").then(ClientCommands.literal((String)"idle").executes(requirement -> AFKCommand.changeAFKMode((IClientSuggestionProvider)requirement.getSource(), AFKMode.IDLE)))).then(ClientCommands.literal((String)"random_move").executes(requirement -> AFKCommand.changeAFKMode((IClientSuggestionProvider)requirement.getSource(), AFKMode.RANDOM_MOVE)))).then(ClientCommands.literal((String)"random_360").executes(requirement -> AFKCommand.changeAFKMode((IClientSuggestionProvider)requirement.getSource(), AFKMode.RANDOM_360)))).then(ClientCommands.literal((String)"random_move_360").executes(requirement -> AFKCommand.changeAFKMode((IClientSuggestionProvider)requirement.getSource(), AFKMode.RANDOM_MOVE_360)))));
    }

    private static int startAFK(IClientSuggestionProvider source, String reason) {
        if (InfoUtils.INSTANCE.isHypixel()) {
            throw new CommandException(LangUtils.translate((String)"commands.not_allowed_hypixel"));
        }
        if (!IndicatiaEventHandler.START_AFK) {
            IndicatiaEventHandler.START_AFK = true;
            IndicatiaEventHandler.AFK_REASON = reason;
            reason = StringUtils.func_151246_b((String)reason) ? "" : ", " + LangUtils.translate((String)"commands.afk.reason").getString() + ": " + reason;
            String message = LangUtils.translate((String)"commands.afk.afk_now").getString();
            if (((Boolean)IndicatiaConfig.GENERAL.enableAFKMessage.get()).booleanValue()) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(message + reason);
            }
            return 1;
        }
        source.sendErrorMessage(LangUtils.translate((String)"commands.afk.afk_started"));
        return 1;
    }

    private static int stopAFK(IClientSuggestionProvider source) {
        if (IndicatiaEventHandler.START_AFK) {
            IndicatiaEventHandler.START_AFK = false;
            IndicatiaEventHandler.afkMoveTicks = 0;
            if (((Boolean)IndicatiaConfig.GENERAL.enableAFKMessage.get()).booleanValue()) {
                if (StringUtils.func_151246_b((String)IndicatiaEventHandler.AFK_REASON)) {
                    Minecraft.func_71410_x().field_71439_g.func_71165_d(LangUtils.translate((String)"commands.afk.afk_stopped", (Object[])new Object[]{CommonUtils.ticksToElapsedTime((int)IndicatiaEventHandler.afkTicks)}).getString());
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_71165_d(LangUtils.translate((String)"commands.afk.afk_stopped_with_reason", (Object[])new Object[]{IndicatiaEventHandler.AFK_REASON, CommonUtils.ticksToElapsedTime((int)IndicatiaEventHandler.afkTicks)}).getString());
                }
            }
            return 1;
        }
        source.sendErrorMessage(LangUtils.translate((String)"commands.afk.afk_not_started"));
        return 1;
    }

    private static int setReason(IClientSuggestionProvider source, String newReason) {
        if (IndicatiaEventHandler.START_AFK) {
            String oldReason = IndicatiaEventHandler.AFK_REASON;
            IndicatiaEventHandler.AFK_REASON = newReason;
            source.sendFeedback(LangUtils.translate((String)"commands.afk.change_afk_reason", (Object[])new Object[]{oldReason, newReason}));
            return 1;
        }
        source.sendErrorMessage(LangUtils.translate((String)"commands.afk.afk_not_started"));
        return 1;
    }

    private static int changeAFKMode(IClientSuggestionProvider source, AFKMode mode) {
        IndicatiaEventHandler.AFK_MODE = mode;
        source.sendFeedback(LangUtils.translate((String)"commands.afk.set_afk_mode", (Object[])new Object[]{mode}));
        return 1;
    }
}

