/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.stevekung.indicatia.command.arguments.ProfileNameArgumentType;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.stevekungslib.utils.LangUtils;
import com.stevekung.stevekungslib.utils.client.command.ClientCommands;
import com.stevekung.stevekungslib.utils.client.command.IClientCommand;
import com.stevekung.stevekungslib.utils.client.command.IClientSuggestionProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ProfileCommand
implements IClientCommand {
    public void register(CommandDispatcher<IClientSuggestionProvider> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommands.literal((String)"inprofile").then(ClientCommands.literal((String)"add").then(ClientCommands.argument((String)"profile_name", (ArgumentType)ProfileNameArgumentType.create(ProfileNameArgumentType.Mode.ADD)).executes(requirement -> ProfileCommand.addProfile((IClientSuggestionProvider)requirement.getSource(), ProfileNameArgumentType.getProfile((CommandContext<IClientSuggestionProvider>)requirement, "profile_name")))))).then(ClientCommands.literal((String)"load").then(ClientCommands.argument((String)"profile_name", (ArgumentType)ProfileNameArgumentType.create()).executes(requirement -> ProfileCommand.loadProfile((IClientSuggestionProvider)requirement.getSource(), ProfileNameArgumentType.getProfile((CommandContext<IClientSuggestionProvider>)requirement, "profile_name")))))).then(ClientCommands.literal((String)"save").then(ClientCommands.argument((String)"profile_name", (ArgumentType)ProfileNameArgumentType.create()).executes(requirement -> ProfileCommand.saveProfile((IClientSuggestionProvider)requirement.getSource(), ProfileNameArgumentType.getProfile((CommandContext<IClientSuggestionProvider>)requirement, "profile_name")))))).then(ClientCommands.literal((String)"remove").then(ClientCommands.argument((String)"profile_name", (ArgumentType)ProfileNameArgumentType.create(ProfileNameArgumentType.Mode.REMOVE)).executes(requirement -> ProfileCommand.removeProfile((IClientSuggestionProvider)requirement.getSource(), ProfileNameArgumentType.getProfile((CommandContext<IClientSuggestionProvider>)requirement, "profile_name")))))).then(ClientCommands.literal((String)"list").executes(requirement -> ProfileCommand.getProfileList((IClientSuggestionProvider)requirement.getSource()))));
    }

    private static int addProfile(IClientSuggestionProvider source, String name) {
        boolean exist = false;
        if (name.equalsIgnoreCase("default")) {
            source.sendErrorMessage(LangUtils.translate((String)"commands.inprofile.cannot_create_default"));
            return 0;
        }
        for (File file : IndicatiaSettings.USER_DIR.listFiles()) {
            if (!name.equalsIgnoreCase(file.getName().replace(".dat", ""))) continue;
            exist = file.getName().equalsIgnoreCase(name + ".dat") && file.exists();
        }
        if (exist) {
            source.sendErrorMessage(LangUtils.translate((String)"commands.inprofile.profile_already_created", (Object[])new Object[]{name}));
            return 0;
        }
        source.sendFeedback(LangUtils.translate((String)"commands.inprofile.created", (Object[])new Object[]{name}));
        IndicatiaSettings.INSTANCE.save(name);
        return 1;
    }

    private static int loadProfile(IClientSuggestionProvider source, String name) {
        for (File file : IndicatiaSettings.USER_DIR.listFiles()) {
            if (file.getName().equals(name + ".dat")) continue;
            source.sendErrorMessage(LangUtils.translate((String)"commands.inprofile.cannot_load"));
            return 0;
        }
        IndicatiaSettings.setCurrentProfile(name);
        IndicatiaSettings.saveProfileFile(name);
        IndicatiaSettings.INSTANCE.load();
        source.sendFeedback(LangUtils.translate((String)"commands.inprofile.load", (Object[])new Object[]{name}));
        IndicatiaSettings.INSTANCE.save(name);
        return 1;
    }

    private static int saveProfile(IClientSuggestionProvider source, String name) {
        boolean exist = false;
        for (File file : IndicatiaSettings.USER_DIR.listFiles()) {
            if (!name.equalsIgnoreCase(file.getName().replace(".dat", ""))) continue;
            exist = file.getName().equalsIgnoreCase(name + ".dat") && file.exists();
        }
        if (exist) {
            IndicatiaSettings.INSTANCE.save(name);
            source.sendFeedback(LangUtils.translate((String)"commands.inprofile.save", (Object[])new Object[]{name}));
            return 1;
        }
        source.sendErrorMessage(LangUtils.translate((String)"commands.inprofile.cannot_save", (Object[])new Object[]{name}));
        return 0;
    }

    private static int removeProfile(IClientSuggestionProvider source, String name) {
        if (name.equals("default")) {
            source.sendErrorMessage(LangUtils.translate((String)"commands.inprofile.cannot_remove_default"));
            return 0;
        }
        boolean exist = false;
        for (File file : IndicatiaSettings.USER_DIR.listFiles()) {
            if (!name.equalsIgnoreCase(file.getName().replace(".dat", ""))) continue;
            exist = file.getName().equalsIgnoreCase(name + ".dat") && file.exists();
        }
        if (exist) {
            File toDel = new File(IndicatiaSettings.USER_DIR, name + ".dat");
            toDel.delete();
            IndicatiaSettings.setCurrentProfile("default");
            IndicatiaSettings.INSTANCE.load();
            source.sendFeedback(LangUtils.translate((String)"commands.inprofile.remove", (Object[])new Object[]{name}));
            return 1;
        }
        source.sendErrorMessage(LangUtils.translate((String)"commands.inprofile.cannot_remove", (Object[])new Object[]{name}));
        return 0;
    }

    private static int getProfileList(IClientSuggestionProvider source) {
        Collection collection = Arrays.stream(IndicatiaSettings.USER_DIR.listFiles()).filter(file -> file.getName().endsWith(".dat")).collect(Collectors.toList());
        if (collection.isEmpty()) {
            source.sendErrorMessage(LangUtils.translate((String)"commands.inprofile.list.empty"));
            return 0;
        }
        ITextComponent translation = LangUtils.translate((String)"commands.inprofile.list.count", (Object[])new Object[]{collection.size()});
        translation.func_150256_b().func_240712_a_(TextFormatting.DARK_GREEN);
        source.sendFeedback(translation);
        collection.forEach(file -> {
            String name = file.getName();
            String realName = name.replace(".dat", "");
            boolean current = realName.equals(IndicatiaSettings.CURRENT_PROFILE);
            source.sendFeedback(LangUtils.translate((String)"commands.inprofile.list.entry", (Object[])new Object[]{realName, current ? "- " + TextFormatting.RED + LangUtils.translate((String)"commands.inprofile.current_profile").getString() : ""}));
        });
        return 1;
    }
}

