/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.stevekungslib.utils.client.command.IClientSuggestionProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.TranslationTextComponent;

public class ProfileNameArgumentType
implements ArgumentType<String> {
    private static final DynamicCommandExceptionType PROFILE_NOT_FOUND = new DynamicCommandExceptionType(obj -> new TranslationTextComponent("commands.inprofile.not_found", new Object[]{obj}));
    private static final SimpleCommandExceptionType CANNOT_REMOVE_DEFAULT = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.inprofile.cannot_remove_default"));
    private static final SimpleCommandExceptionType CANNOT_CREATE_DEFAULT = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.inprofile.cannot_create_default"));
    private static final SimpleCommandExceptionType INVALID_ARGS = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.id.invalid"));
    private final Mode mode;

    private ProfileNameArgumentType(Mode mode) {
        this.mode = mode;
    }

    public static ProfileNameArgumentType create() {
        return ProfileNameArgumentType.create(Mode.NONE);
    }

    public static ProfileNameArgumentType create(Mode mode) {
        return new ProfileNameArgumentType(mode);
    }

    public static String getProfile(CommandContext<IClientSuggestionProvider> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        List<String> resList = Arrays.stream(IndicatiaSettings.USER_DIR.listFiles()).filter(file -> this.mode == Mode.REMOVE ? file.getName().endsWith(".dat") && !file.getName().equals("default.dat") : file.getName().endsWith(".dat")).map(file -> file.getName().replace(".dat", "")).collect(Collectors.toList());
        return this.mode == Mode.ADD ? Suggestions.empty() : ProfileNameArgumentType.suggestIterable(resList, builder);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String fileName = ProfileNameArgumentType.read(reader);
        boolean exist = false;
        boolean remove = false;
        if (IndicatiaSettings.USER_DIR.exists()) {
            for (File file : IndicatiaSettings.USER_DIR.listFiles()) {
                String name = file.getName();
                if (name.equals(fileName + ".dat") && name.endsWith(".dat")) {
                    exist = true;
                }
                if (this.mode != Mode.REMOVE && this.mode != Mode.ADD || !fileName.equals("default") || !name.equals(fileName + ".dat")) continue;
                remove = true;
            }
        }
        if (remove) {
            if (this.mode == Mode.ADD) {
                throw CANNOT_CREATE_DEFAULT.create();
            }
            throw CANNOT_REMOVE_DEFAULT.create();
        }
        if (this.mode == Mode.REMOVE) {
            try {
                if (exist) {
                    return fileName;
                }
                throw PROFILE_NOT_FOUND.create((Object)fileName);
            }
            catch (Exception e) {
                return fileName;
            }
        }
        return fileName;
    }

    public Collection<String> getExamples() {
        return Collections.singletonList("profile");
    }

    private static CompletableFuture<Suggestions> suggestIterable(Iterable<String> iterable, SuggestionsBuilder builder) {
        String typedString = builder.getRemaining().toLowerCase(Locale.ROOT);
        ProfileNameArgumentType.applySuggest(iterable, typedString, string1 -> string1, arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static void applySuggest(Iterable<String> iterable, String typedString, Function<String, String> function, Consumer<String> consumer) {
        for (String name : iterable) {
            String name2 = function.apply(name);
            if (!name2.startsWith(typedString)) continue;
            consumer.accept(name);
        }
    }

    private static String read(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && ResourceLocation.func_195824_a((char)reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return string;
        }
        catch (ResourceLocationException e) {
            reader.setCursor(cursor);
            throw INVALID_ARGS.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static enum Mode {
        NONE,
        ADD,
        REMOVE;

    }
}

