/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.core;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.stevekung.indicatia.command.AFKCommand;
import com.stevekung.indicatia.command.AutoFishCommand;
import com.stevekung.indicatia.command.MojangStatusCheckCommand;
import com.stevekung.indicatia.command.PingAllCommand;
import com.stevekung.indicatia.command.ProfileCommand;
import com.stevekung.indicatia.command.SlimeSeedCommand;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.indicatia.event.HUDRenderEventHandler;
import com.stevekung.indicatia.event.HypixelEventHandler;
import com.stevekung.indicatia.event.IndicatiaEventHandler;
import com.stevekung.indicatia.gui.screen.IndicatiaChatScreen;
import com.stevekung.indicatia.handler.KeyBindingHandler;
import com.stevekung.indicatia.key.KeypadChatKey;
import com.stevekung.indicatia.utils.ThreadMinigameData;
import com.stevekung.stevekungslib.utils.CommonUtils;
import com.stevekung.stevekungslib.utils.LoggerBase;
import com.stevekung.stevekungslib.utils.ModVersionChecker;
import com.stevekung.stevekungslib.utils.client.command.ClientCommands;
import com.stevekung.stevekungslib.utils.client.command.IClientCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod(value="indicatia")
public class IndicatiaMod {
    public static final String MOD_ID = "indicatia";
    private static final File PROFILE = new File(IndicatiaSettings.USER_DIR, "profile.txt");
    public static final ModVersionChecker CHECKER = new ModVersionChecker("indicatia");
    public static boolean isGalacticraftLoaded;
    public static final LoggerBase LOGGER;
    private static final Splitter COLON_SPLITTER;
    public static final KeyBinding keyBindAltChat;

    public IndicatiaMod() {
        CommonUtils.addModListener(this::phaseOne);
        CommonUtils.addModListener(this::loadComplete);
        CommonUtils.registerConfig((ModConfig.Type)ModConfig.Type.CLIENT, (ForgeConfigSpec.Builder)IndicatiaConfig.GENERAL_BUILDER);
        CommonUtils.registerModEventBus(IndicatiaConfig.class);
        isGalacticraftLoaded = ModList.get().isLoaded("galacticraftcore");
    }

    private void phaseOne(FMLClientSetupEvent event) {
        this.registerClientCommands();
        KeyBindingHandler.init();
        CommonUtils.registerEventHandler((Object)new HUDRenderEventHandler());
        CommonUtils.registerEventHandler((Object)new IndicatiaEventHandler());
        CommonUtils.registerEventHandler((Object)new HypixelEventHandler());
        CommonUtils.registerEventHandler((Object)new IndicatiaChatScreen());
        IndicatiaMod.loadProfileOption();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        CommonUtils.runAsync(ThreadMinigameData::new);
        if (((Boolean)IndicatiaConfig.GENERAL.enableVersionChecker.get()).booleanValue()) {
            CHECKER.startCheck();
        }
    }

    private void registerClientCommands() {
        ClientCommands.register((IClientCommand)new AFKCommand());
        ClientCommands.register((IClientCommand)new AutoFishCommand());
        ClientCommands.register((IClientCommand)new MojangStatusCheckCommand());
        ClientCommands.register((IClientCommand)new PingAllCommand());
        ClientCommands.register((IClientCommand)new ProfileCommand());
        ClientCommands.register((IClientCommand)new SlimeSeedCommand());
        LOGGER.info("Registering client side commands");
    }

    private static void loadProfileOption() {
        if (!PROFILE.exists()) {
            return;
        }
        if (!IndicatiaSettings.DEFAULT_CONFIG_FILE.exists()) {
            LOGGER.info("Creating default profile...");
            IndicatiaSettings.setCurrentProfile("default");
            IndicatiaSettings.INSTANCE.save();
        }
        CompoundNBT nbt = new CompoundNBT();
        try (BufferedReader reader = Files.newReader((File)PROFILE, (Charset)Charsets.UTF_8);){
            reader.lines().forEach(option -> {
                try {
                    Iterator iterator = COLON_SPLITTER.split((CharSequence)option).iterator();
                    nbt.func_74778_a((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String property : nbt.func_150296_c()) {
            String key = nbt.func_74779_i(property);
            if (!"profile".equals(property)) continue;
            LOGGER.info("Load current profile '{}'", new Object[]{key});
            IndicatiaSettings.setCurrentProfile(key);
            IndicatiaSettings.INSTANCE.load();
        }
    }

    private static void initProfileFile() {
        if (!IndicatiaSettings.INDICATIA_DIR.exists()) {
            IndicatiaSettings.INDICATIA_DIR.mkdirs();
        }
        if (!IndicatiaSettings.USER_DIR.exists()) {
            IndicatiaSettings.USER_DIR.mkdirs();
        }
        if (!PROFILE.exists()) {
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(PROFILE), StandardCharsets.UTF_8));){
                writer.println("profile:default");
                LOGGER.info("Creating profile option at {}", new Object[]{PROFILE.getPath()});
            }
            catch (IOException e) {
                LOGGER.error("Failed to save profile");
                e.printStackTrace();
            }
        }
    }

    static {
        LOGGER = new LoggerBase("Indicatia");
        COLON_SPLITTER = Splitter.on((char)':').limit(2);
        keyBindAltChat = new KeyBinding("key.chatAlt", (IKeyConflictContext)new KeypadChatKey(), InputMappings.Type.KEYSYM, 335, "key.categories.multiplayer");
        IndicatiaMod.initProfileFile();
    }
}

