/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.stevekung.indicatia.config.Equipments;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.indicatia.gui.exconfig.screen.OffsetRenderPreviewScreen;
import com.stevekung.indicatia.hud.EffectOverlays;
import com.stevekung.indicatia.hud.EquipmentOverlays;
import com.stevekung.indicatia.hud.InfoOverlays;
import com.stevekung.indicatia.hud.InfoUtils;
import com.stevekung.indicatia.utils.event.InfoOverlayEvent;
import com.stevekung.indicatia.utils.hud.InfoOverlay;
import com.stevekung.stevekungslib.utils.CommonUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.versions.mcp.MCPVersion;

public class HUDRenderEventHandler {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.START && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            InfoOverlays.getTPS(server);
        }
    }

    @SubscribeEvent
    public void onPreInfoRender(RenderGameOverlayEvent.Pre event) {
        MatrixStack matrixStack = event.getMatrixStack();
        if (event.getType() == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            event.setCanceled((Boolean)IndicatiaConfig.GENERAL.enableRenderBossHealthStatus.get() == false);
            RenderSystem.enableDepthTest();
            RenderSystem.defaultBlendFunc();
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && !((Boolean)IndicatiaConfig.GENERAL.enableVanillaPotionHUD.get()).booleanValue()) {
            event.setCanceled(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            if (!this.mc.field_71474_y.field_74330_P) {
                if (((Boolean)IndicatiaConfig.GENERAL.enableRenderInfo.get()).booleanValue() && this.mc.field_71439_g != null && this.mc.field_71441_e != null && !(this.mc.field_71462_r instanceof OffsetRenderPreviewScreen)) {
                    int iLeft = 0;
                    int iRight = 0;
                    for (InfoOverlay info : HUDRenderEventHandler.getInfoOverlays(this.mc)) {
                        if (info.isEmpty()) continue;
                        IFormattableTextComponent value = info.toFormatted();
                        InfoOverlay.Position pos = info.getPos();
                        float defaultPos = 3.0625f;
                        Objects.requireNonNull(this.mc.field_71466_p);
                        float fontHeight = 9 + 1;
                        float yOffset = 3.0f + fontHeight * (float)(pos == InfoOverlay.Position.LEFT ? iLeft : iRight);
                        float xOffset = this.mc.func_228018_at_().func_198107_o() - 2 - this.mc.field_71466_p.func_78256_a(value.getString());
                        this.mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)value, pos == InfoOverlay.Position.LEFT ? (!IndicatiaSettings.INSTANCE.swapRenderInfo ? defaultPos : xOffset) : (pos == InfoOverlay.Position.RIGHT ? (!IndicatiaSettings.INSTANCE.swapRenderInfo ? xOffset : defaultPos) : defaultPos), yOffset, 0xFFFFFF);
                        if (pos == InfoOverlay.Position.LEFT) {
                            ++iLeft;
                            continue;
                        }
                        ++iRight;
                    }
                }
                if (!this.mc.field_71439_g.func_175149_v() && IndicatiaSettings.INSTANCE.equipmentHUD) {
                    if (IndicatiaSettings.INSTANCE.equipmentPosition == Equipments.Position.HOTBAR) {
                        EquipmentOverlays.renderHotbarEquippedItems(this.mc, matrixStack);
                    } else if (IndicatiaSettings.INSTANCE.equipmentDirection == Equipments.Direction.VERTICAL) {
                        EquipmentOverlays.renderVerticalEquippedItems(this.mc, matrixStack);
                    } else {
                        EquipmentOverlays.renderHorizontalEquippedItems(this.mc, matrixStack);
                    }
                }
                if (IndicatiaSettings.INSTANCE.potionHUD) {
                    EffectOverlays.renderPotionHUD(this.mc, matrixStack);
                }
            }
        } else if (this.mc.field_71462_r instanceof OffsetRenderPreviewScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        InfoOverlays.OVERALL_TPS = InfoOverlay.empty();
        InfoOverlays.OVERWORLD_TPS = InfoOverlay.empty();
        InfoOverlays.TPS = InfoOverlay.empty();
        InfoOverlays.ALL_TPS.clear();
    }

    public static List<InfoOverlay> getInfoOverlays(Minecraft mc) {
        ArrayList infos = Lists.newArrayList();
        BlockPos playerPos = new BlockPos(mc.func_175606_aa().func_226277_ct_(), mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().func_226281_cx_());
        if (IndicatiaSettings.INSTANCE.fps) {
            int fps = Minecraft.field_71470_ab;
            infos.add(new InfoOverlay("hud.fps", String.valueOf(fps), IndicatiaSettings.INSTANCE.fpsColor, fps <= 25 ? IndicatiaSettings.INSTANCE.fpsLow25Color : (fps >= 26 && fps <= 49 ? IndicatiaSettings.INSTANCE.fps26And49Color : IndicatiaSettings.INSTANCE.fpsValueColor), InfoOverlay.Position.LEFT));
        }
        if (!mc.func_71356_B()) {
            if (IndicatiaSettings.INSTANCE.ping) {
                int responseTime = InfoUtils.INSTANCE.getPing();
                infos.add(new InfoOverlay("hud.ping", responseTime + "ms", IndicatiaSettings.INSTANCE.pingColor, InfoUtils.INSTANCE.getResponseTimeColor(responseTime), InfoOverlay.Position.RIGHT));
                if (IndicatiaSettings.INSTANCE.pingToSecond) {
                    double responseTimeSecond = (double)InfoUtils.INSTANCE.getPing() / 1000.0;
                    infos.add(new InfoOverlay("hud.ping.delay", responseTimeSecond + "s", IndicatiaSettings.INSTANCE.pingToSecondColor, InfoUtils.INSTANCE.getResponseTimeColor((int)(responseTimeSecond * 1000.0)), InfoOverlay.Position.RIGHT));
                }
            }
            if (IndicatiaSettings.INSTANCE.serverIP && mc.func_147104_D() != null) {
                infos.add(new InfoOverlay("IP", (mc.func_181540_al() ? "Realms Server" : mc.func_147104_D().field_78845_b) + (IndicatiaSettings.INSTANCE.serverIPMCVersion ? "/" + MCPVersion.getMCVersion() : ""), IndicatiaSettings.INSTANCE.serverIPColor, IndicatiaSettings.INSTANCE.serverIPValueColor, InfoOverlay.Position.RIGHT));
            }
        }
        if (IndicatiaSettings.INSTANCE.xyz) {
            String stringPos = playerPos.func_177958_n() + " " + playerPos.func_177956_o() + " " + playerPos.func_177952_p();
            String nether = mc.field_71439_g.field_70170_p.func_230315_m_().func_241509_i_() ? "Nether " : "";
            infos.add(new InfoOverlay(nether + "XYZ", stringPos, IndicatiaSettings.INSTANCE.xyzColor, IndicatiaSettings.INSTANCE.xyzValueColor, InfoOverlay.Position.LEFT));
            if (mc.field_71439_g.field_70170_p.func_230315_m_().func_241509_i_()) {
                String stringNetherPos = playerPos.func_177958_n() * 8 + " " + playerPos.func_177956_o() + " " + playerPos.func_177952_p() * 8;
                infos.add(new InfoOverlay("Overworld XYZ", stringNetherPos, IndicatiaSettings.INSTANCE.xyzColor, IndicatiaSettings.INSTANCE.xyzValueColor, InfoOverlay.Position.LEFT));
            }
        }
        if (IndicatiaSettings.INSTANCE.direction) {
            infos.add(InfoOverlays.getDirection(mc));
        }
        if (IndicatiaSettings.INSTANCE.biome) {
            ChunkPos chunkPos = new ChunkPos(playerPos);
            Chunk worldChunk = mc.field_71441_e.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
            ResourceLocation biomeResource = mc.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)mc.field_71441_e.func_226691_t_(playerPos));
            String biomeName = "biome." + biomeResource.func_110624_b() + "." + biomeResource.func_110623_a();
            infos.add(new InfoOverlay("hud.biome", !worldChunk.func_76621_g() ? new TranslationTextComponent(biomeName).getString() : LangUtils.translate((String)"hud.biome.waiting_for_chunk").getString(), IndicatiaSettings.INSTANCE.biomeColor, IndicatiaSettings.INSTANCE.biomeValueColor, InfoOverlay.Position.LEFT));
        }
        if (IndicatiaSettings.INSTANCE.slimeChunkFinder && !mc.field_71439_g.field_70170_p.func_230315_m_().func_241509_i_()) {
            infos.add(new InfoOverlay("hud.slime_chunk", InfoUtils.INSTANCE.isSlimeChunk(mc.field_71439_g.func_233580_cy_()) ? "gui.yes" : "gui.no", IndicatiaSettings.INSTANCE.slimeChunkColor, IndicatiaSettings.INSTANCE.slimeChunkValueColor, InfoOverlay.Position.LEFT));
        }
        if (IndicatiaSettings.INSTANCE.tps) {
            infos.add(InfoOverlays.OVERALL_TPS);
            infos.add(InfoOverlays.OVERWORLD_TPS);
            infos.addAll(InfoOverlays.ALL_TPS);
            infos.add(InfoOverlays.TPS);
        }
        if (IndicatiaSettings.INSTANCE.realTime) {
            infos.add(InfoOverlays.getRealWorldTime());
        }
        if (IndicatiaSettings.INSTANCE.gameTime) {
            infos.add(InfoOverlays.getGameTime(mc));
        }
        if (IndicatiaSettings.INSTANCE.gameWeather && mc.field_71441_e.func_72896_J()) {
            String weather = !mc.field_71441_e.func_72911_I() ? "hud.weather.raining" : "hud.weather.thundering";
            infos.add(new InfoOverlay("hud.weather", weather, IndicatiaSettings.INSTANCE.gameWeatherColor, IndicatiaSettings.INSTANCE.gameWeatherValueColor, InfoOverlay.Position.RIGHT));
        }
        if (IndicatiaSettings.INSTANCE.moonPhase) {
            infos.add(new InfoOverlay("hud.moon_phase", InfoUtils.INSTANCE.getMoonPhase(mc), IndicatiaSettings.INSTANCE.moonPhaseColor, IndicatiaSettings.INSTANCE.moonPhaseValueColor, InfoOverlay.Position.RIGHT));
        }
        CommonUtils.post((Event)new InfoOverlayEvent(infos));
        return infos;
    }
}

