/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.indicatia.gui.widget.DropdownMinigamesButton;
import com.stevekung.indicatia.gui.widget.MinigameButton;
import com.stevekung.indicatia.hud.InfoUtils;
import com.stevekung.indicatia.utils.MinigameData;
import com.stevekung.stevekungslib.utils.ColorUtils;
import com.stevekung.stevekungslib.utils.ItemUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import com.stevekung.stevekungslib.utils.TextComponentUtils;
import com.stevekung.stevekungslib.utils.client.ClientUtils;
import com.stevekung.stevekungslib.utils.client.event.ChatScreenEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IndicatiaChatScreen
implements DropdownMinigamesButton.IDropboxCallback {
    private DropdownMinigamesButton dropdown;
    private int prevSelect = -1;
    private ChatMode mode = ChatMode.ALL;

    @SubscribeEvent
    public void onChatInit(ChatScreenEvent.Init event) {
        if (InfoUtils.INSTANCE.isHypixel()) {
            this.updateButton(event.getButtons(), event.getChildren(), event.getWidth(), event.getHeight());
            if (IndicatiaSettings.INSTANCE.chatMode < ChatMode.values().length) {
                this.mode = ChatMode.values()[IndicatiaSettings.INSTANCE.chatMode];
            }
        }
    }

    @SubscribeEvent
    public void onChatRenderPre(ChatScreenEvent.RenderPre event) {
        if (InfoUtils.INSTANCE.isHypixel() && ((Boolean)IndicatiaConfig.GENERAL.enableHypixelChatMode.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            IFormattableTextComponent chatMode = LangUtils.translate((String)"menu.chat_mode").func_230532_e_().func_240702_b_(": ").func_230529_a_((ITextComponent)LangUtils.translate((String)this.mode.desc).func_230532_e_().func_240701_a_(new TextFormatting[]{this.mode.color, TextFormatting.BOLD}));
            int x = 4;
            int y = mc.field_71462_r.field_230709_l_ - 30;
            AbstractGui.func_238467_a_((MatrixStack)event.getMatrixStack(), (int)(x - 2), (int)(y - 3), (int)(x + mc.field_71466_p.func_238414_a_((ITextProperties)chatMode) + 2), (int)(y + 10), (int)ColorUtils.to32Bit((int)0, (int)0, (int)0, (int)128));
            mc.field_71466_p.func_243246_a(event.getMatrixStack(), (ITextComponent)chatMode, (float)x, (float)y, ColorUtils.toDecimal((int)255, (int)255, (int)255));
        }
    }

    @SubscribeEvent
    public void onChatRenderPost(ChatScreenEvent.RenderPost event) {
        if (InfoUtils.INSTANCE.isHypixel() && ((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue()) {
            for (Widget button : event.getButtons()) {
                if (!(button instanceof MinigameButton)) continue;
                MinigameButton customButton = (MinigameButton)button;
                customButton.render(event.getMatrixStack(), event.getMouseX(), event.getMouseY());
            }
        }
    }

    @SubscribeEvent
    public void onChatTick(ChatScreenEvent.Tick event) {
        if (InfoUtils.INSTANCE.isHypixel() && ((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue()) {
            if (this.prevSelect != IndicatiaSettings.INSTANCE.selectedHypixelMinigame) {
                this.updateButton(event.getButtons(), event.getChildren(), event.getWidth(), event.getHeight());
                this.prevSelect = IndicatiaSettings.INSTANCE.selectedHypixelMinigame;
            }
            boolean clicked = !this.dropdown.dropdownClicked;
            for (Widget button : event.getButtons()) {
                if (!(button instanceof MinigameButton)) continue;
                MinigameButton buttonCustom = (MinigameButton)button;
                buttonCustom.field_230694_p_ = clicked;
            }
        }
    }

    @SubscribeEvent
    public void onChatClose(ChatScreenEvent.Close event) {
        IndicatiaSettings.INSTANCE.save();
    }

    @SubscribeEvent
    public void onChatMouseScrolled(ChatScreenEvent.MouseScroll event) {
        double delta = event.getScrollDelta();
        if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue() && this.dropdown != null && this.dropdown.dropdownClicked && this.dropdown.isHoverDropdown(event.getMouseX(), event.getMouseY())) {
            if (delta > 1.0) {
                delta = 1.0;
            }
            if (delta < -1.0) {
                delta = -1.0;
            }
            if (ClientUtils.isControlKeyDown()) {
                delta *= 7.0;
            }
            this.dropdown.scroll(delta);
            event.setCanceled(true);
        }
    }

    @Override
    public void onSelectionChanged(DropdownMinigamesButton dropdown, int selection) {
        IndicatiaSettings.INSTANCE.selectedHypixelMinigame = selection;
        IndicatiaSettings.INSTANCE.save();
    }

    @Override
    public int getInitialSelection(DropdownMinigamesButton dropdown) {
        return IndicatiaSettings.INSTANCE.selectedHypixelMinigame;
    }

    private void updateButton(List<Widget> buttons, List<IGuiEventListener> children, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        buttons.clear();
        children.clear();
        if (player == null || !(mc.field_71462_r instanceof ChatScreen)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (MinigameData data : MinigameData.DATA) {
            list.add(data.getName());
        }
        String max = Collections.max(list, Comparator.comparing(String::length));
        int length = mc.field_71466_p.func_78256_a(max) + 32;
        if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelChatMode.get()).booleanValue()) {
            for (ChatMode mode : ChatMode.values()) {
                buttons.add((Widget)new Button(width - mode.x, height - mode.y, mode.width, mode.height, mode.message, button -> {
                    this.mode = mode;
                    player.func_71165_d(mode.command);
                    IndicatiaSettings.INSTANCE.chatMode = mode.ordinal();
                }));
            }
        }
        if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue()) {
            this.dropdown = new DropdownMinigamesButton(this, width - length, 2, list);
            buttons.add((Widget)this.dropdown);
            this.dropdown.func_230991_b_(length);
            this.prevSelect = IndicatiaSettings.INSTANCE.selectedHypixelMinigame;
            ArrayList gameBtn = Lists.newArrayList();
            int xPos2 = width - 99;
            if (this.prevSelect > list.size()) {
                this.prevSelect = 0;
                IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos = 0;
                IndicatiaSettings.INSTANCE.selectedHypixelMinigame = 0;
            }
            for (MinigameData data : MinigameData.DATA) {
                for (MinigameData.Command command : data.getCommands()) {
                    if (!data.getName().equals(list.get(this.prevSelect))) continue;
                    ItemStack skull = ItemStack.field_190927_a;
                    if (!StringUtils.func_151246_b((String)command.getUUID())) {
                        skull = ItemUtils.getSkullItemStack((String)command.getUUID(), (String)command.getTexture());
                    }
                    gameBtn.add(new MinigameButton(width, (ITextComponent)TextComponentUtils.component((String)command.getName()), command.isMinigame(), button -> player.func_71165_d(command.getCommand().startsWith("/") ? command.getCommand() : (command.isMinigame() ? "/play " + command.getCommand() : "/lobby " + command.getCommand())), skull));
                }
            }
            for (int i = 0; i < gameBtn.size(); ++i) {
                MinigameButton button2 = (MinigameButton)((Object)gameBtn.get(i));
                if (i >= 6 && i <= 10) {
                    button2.field_230690_l_ = xPos2 - 136;
                    button2.field_230691_m_ = 41;
                } else if (i >= 11 && i <= 15) {
                    button2.field_230690_l_ = xPos2 - 241;
                    button2.field_230691_m_ = 62;
                } else if (i >= 16 && i <= 20) {
                    button2.field_230690_l_ = xPos2 - 346;
                    button2.field_230691_m_ = 83;
                } else if (i >= 21) {
                    button2.field_230690_l_ = xPos2 - 451;
                    button2.field_230691_m_ = 104;
                }
                button2.field_230690_l_ += 21 * i;
                buttons.add((Widget)button2);
            }
        }
        for (Widget button3 : buttons) {
            if (!(button3 instanceof MinigameButton)) continue;
            button3.field_230694_p_ = false;
        }
        children.addAll(buttons);
    }

    public static enum ChatMode implements IExtensibleEnum
    {
        ALL("menu.chat_mode.all_chat", TextFormatting.GRAY, 23, 35, 20, 20, "A", "/chat a"),
        PARTY("menu.chat_mode.party_chat", TextFormatting.BLUE, 23, 56, 20, 20, "P", "/chat p"),
        GUILD("menu.chat_mode.guild_chat", TextFormatting.DARK_GREEN, 23, 77, 20, 20, "G", "/chat g");

        protected final String desc;
        protected final TextFormatting color;
        protected final int x;
        protected final int y;
        protected final int width;
        protected final int height;
        protected final ITextComponent message;
        public final String command;

        private ChatMode(String desc, TextFormatting color, int x, int y, int width, int height, String message, String command) {
            this.desc = desc;
            this.color = color;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.message = LangUtils.translate((String)message);
            this.command = command;
        }

        public static ChatMode create(String name, String desc, TextFormatting color, int x, int y, int width, int height, String message, String command) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

