/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.stevekungslib.utils.ColorUtils;
import com.stevekung.stevekungslib.utils.TextComponentUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class DropdownMinigamesButton
extends Button {
    private static final ResourceLocation TEXTURE = new ResourceLocation("indicatia:textures/gui/dropdown.png");
    public boolean dropdownClicked;
    private int selectedMinigame = -1;
    private final List<String> minigameLists;
    private final IDropboxCallback parentClass;
    private final int displayLength;

    public DropdownMinigamesButton(IDropboxCallback parentClass, int x, int y, List<String> minigameLists) {
        super(x, y, 15, 15, (ITextComponent)TextComponentUtils.component((String)"Minigame Dropdown Button"), null);
        this.parentClass = parentClass;
        this.minigameLists = minigameLists;
        this.displayLength = this.minigameLists.size() <= 6 ? this.minigameLists.size() : 6;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        int hoverColor = 150;
        int hoverPos = (mouseY - this.field_230691_m_) / this.field_230689_k_;
        boolean bl = this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        if (!this.dropdownClicked && this.field_230692_n_) {
            hoverColor = 180;
        }
        if (this.selectedMinigame == -1) {
            int size;
            int initSelect = this.parentClass.getInitialSelection(this);
            if (initSelect > (size = this.minigameLists.size() + IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos) || IndicatiaSettings.INSTANCE.selectedHypixelMinigame > size || size == 1) {
                initSelect = 0;
                IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos = 0;
                IndicatiaSettings.INSTANCE.selectedHypixelMinigame = 0;
            }
            this.selectedMinigame = initSelect;
        }
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_ - 15), (int)(this.field_230691_m_ + (this.dropdownClicked ? this.field_230689_k_ * this.displayLength + 15 : this.field_230689_k_)), (int)ColorUtils.to32Bit((int)0, (int)0, (int)0, (int)255));
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (int)(this.field_230690_l_ + this.field_230688_j_ - 16), (int)(this.field_230691_m_ + (this.dropdownClicked ? this.field_230689_k_ * this.displayLength + 15 : this.field_230689_k_) - 1), (int)ColorUtils.to32Bit((int)hoverColor, (int)hoverColor, (int)hoverColor, (int)255));
        if (this.dropdownClicked) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (int)(this.field_230690_l_ + this.field_230688_j_ - 16), (int)(this.field_230691_m_ - 1 + this.field_230689_k_), (int)ColorUtils.to32Bit((int)120, (int)120, (int)120, (int)255));
        }
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.field_230688_j_ - 15), (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_ - 1), (int)(this.field_230691_m_ + this.field_230689_k_), (int)ColorUtils.to32Bit((int)0, (int)0, (int)0, (int)255));
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.field_230688_j_ - 15), (int)(this.field_230691_m_ + 1), (int)(this.field_230690_l_ + this.field_230688_j_ - 2), (int)(this.field_230691_m_ + this.field_230689_k_ - 1), (int)ColorUtils.to32Bit((int)150, (int)150, (int)150, (int)255));
        if (this.displayLength > 1 && this.dropdownClicked) {
            if (this.isHoverDropdown(mouseX, mouseY)) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 2 + this.field_230689_k_ * hoverPos - 1), (int)(this.field_230690_l_ + this.field_230688_j_ - 16), (int)(this.field_230691_m_ + this.field_230689_k_ * (hoverPos + 1) - 1), (int)ColorUtils.to32Bit((int)180, (int)180, (int)180, (int)255));
            }
            if (mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ + 16 && mouseX < this.field_230690_l_ + this.field_230688_j_ - 16 && mouseY < this.field_230691_m_ + this.field_230689_k_ * this.displayLength + 15) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ * hoverPos - 1), (int)(this.field_230690_l_ + this.field_230688_j_ - 16), (int)(this.field_230691_m_ + this.field_230689_k_ * (hoverPos + 1) - 2), (int)ColorUtils.to32Bit((int)180, (int)180, (int)180, (int)255));
            }
        }
        for (int i = 0; i + IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos < this.minigameLists.size() && i < this.displayLength; ++i) {
            String minigames = this.minigameLists.get(i + IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos);
            if (minigames == null) continue;
            if (this.dropdownClicked) {
                mc.field_71466_p.func_238405_a_(matrixStack, minigames, (float)(this.field_230690_l_ + this.field_230688_j_ / 2 - 7 - mc.field_71466_p.func_78256_a(minigames) / 2), (float)(this.field_230691_m_ + (this.field_230689_k_ + 22) / 2 + this.field_230689_k_ * i), ColorUtils.to32Bit((int)255, (int)255, (int)255, (int)255));
                mc.field_71466_p.func_238405_a_(matrixStack, this.minigameLists.get(this.selectedMinigame), (float)(this.field_230690_l_ + this.field_230688_j_ / 2 - 7 - mc.field_71466_p.func_78256_a(this.minigameLists.get(this.selectedMinigame)) / 2), (float)(this.field_230691_m_ + (this.field_230689_k_ - 6) / 2), ColorUtils.to32Bit((int)255, (int)255, (int)255, (int)255));
                continue;
            }
            mc.field_71466_p.func_238405_a_(matrixStack, this.minigameLists.get(this.selectedMinigame), (float)(this.field_230690_l_ + this.field_230688_j_ / 2 - 7 - mc.field_71466_p.func_78256_a(this.minigameLists.get(this.selectedMinigame)) / 2), (float)(this.field_230691_m_ + (this.field_230689_k_ - 6) / 2), ColorUtils.to32Bit((int)255, (int)255, (int)255, (int)255));
        }
        mc.func_110434_K().func_110577_a(TEXTURE);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.field_230688_j_ - 12), (int)(this.field_230691_m_ + 5), (float)0.0f, (float)0.0f, (int)7, (int)4, (int)7, (int)4);
        RenderSystem.popMatrix();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseEvent) {
        if (this.displayLength == 1) {
            return false;
        }
        if (!this.dropdownClicked) {
            if (this.field_230692_n_) {
                this.dropdownClicked = true;
                this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
        } else {
            if (mouseX >= (double)this.field_230690_l_ && mouseY >= (double)(this.field_230691_m_ + 15) && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_ - 16) && mouseY < (double)(this.field_230691_m_ + 15 + this.field_230689_k_ * this.displayLength)) {
                double optionClicked = (mouseY - (double)this.field_230691_m_ - 16.0) / (double)this.field_230689_k_ + (double)IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos;
                this.selectedMinigame = (int)optionClicked % this.minigameLists.size();
                this.dropdownClicked = false;
                this.parentClass.onSelectionChanged(this, this.selectedMinigame);
                this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            this.dropdownClicked = false;
            return false;
        }
        return false;
    }

    public void scroll(double amount) {
        IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos = (int)((double)IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos - amount);
        int i = this.minigameLists.size();
        if (IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos > i - this.displayLength) {
            IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos = i - this.displayLength;
        }
        if (IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos <= 0) {
            IndicatiaSettings.INSTANCE.hypixelMinigameScrollPos = 0;
        }
    }

    public boolean isHoverDropdown(double mouseX, double mouseY) {
        return mouseX >= (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_ - 16) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_ * this.displayLength + 15);
    }

    public static interface IDropboxCallback {
        public void onSelectionChanged(DropdownMinigamesButton var1, int var2);

        public int getInitialSelection(DropdownMinigamesButton var1);
    }
}

