/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.hud;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.stevekung.indicatia.config.Equipments;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.indicatia.utils.hud.EquipmentOverlay;
import com.stevekung.indicatia.utils.hud.HorizontalEquipmentOverlay;
import com.stevekung.indicatia.utils.hud.HotbarEquipmentOverlay;
import com.stevekung.stevekungslib.utils.ColorUtils;
import com.stevekung.stevekungslib.utils.TextComponentUtils;
import com.stevekung.stevekungslib.utils.client.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class EquipmentOverlays {
    public static void renderHorizontalEquippedItems(Minecraft mc, MatrixStack matrixStack) {
        boolean right = IndicatiaSettings.INSTANCE.equipmentPosition == Equipments.Position.RIGHT;
        int baseYOffset = IndicatiaSettings.INSTANCE.armorHUDYOffset;
        ItemStack mainhandStack = mc.field_71439_g.func_184614_ca();
        ItemStack offhandStack = mc.field_71439_g.func_184592_cb();
        ArrayList equippedLists = Lists.newArrayList();
        int prevX = 0;
        if (IndicatiaSettings.INSTANCE.equipmentArmorItems) {
            for (int i = 3; i >= 0; --i) {
                equippedLists.add(new HorizontalEquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)));
            }
        }
        if (IndicatiaSettings.INSTANCE.equipmentHandItems) {
            equippedLists.add(new HorizontalEquipmentOverlay(mainhandStack));
            equippedLists.add(new HorizontalEquipmentOverlay(offhandStack));
        }
        for (HorizontalEquipmentOverlay equipment : equippedLists) {
            ItemStack itemStack = equipment.getItemStack();
            int totalWidth = EquipmentOverlays.getTotalWidth(equippedLists);
            if (itemStack.func_190926_b()) continue;
            int xBaseRight = mc.func_228018_at_().func_198107_o() - totalWidth - 2;
            equipment.render(matrixStack, right ? xBaseRight + prevX + equipment.getWidth() : 2 + prevX, baseYOffset);
            prevX += equipment.getWidth();
        }
    }

    public static void renderVerticalEquippedItems(Minecraft mc, MatrixStack matrixStack) {
        int i = 0;
        ArrayList equippedLists = Lists.newArrayList();
        ItemStack mainhandStack = mc.field_71439_g.func_184614_ca();
        ItemStack offhandStack = mc.field_71439_g.func_184592_cb();
        boolean right = IndicatiaSettings.INSTANCE.equipmentPosition == Equipments.Position.RIGHT;
        int baseXOffset = right ? mc.func_228018_at_().func_198107_o() - 18 : 2;
        int baseYOffset = IndicatiaSettings.INSTANCE.armorHUDYOffset;
        if (IndicatiaSettings.INSTANCE.equipmentArmorItems) {
            for (int armorSlot = 3; armorSlot >= 0; --armorSlot) {
                equippedLists.add(new EquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(armorSlot)));
            }
        }
        if (IndicatiaSettings.INSTANCE.equipmentHandItems) {
            equippedLists.add(new EquipmentOverlay(mainhandStack));
            equippedLists.add(new EquipmentOverlay(offhandStack));
        }
        for (EquipmentOverlay equipment : equippedLists) {
            ItemStack itemStack = equipment.getItemStack();
            if (itemStack.func_190926_b()) continue;
            int equipmentYOffset = baseYOffset + 16 * i;
            String info = equipment.renderInfo();
            IFormattableTextComponent arrowInfo = TextComponentUtils.component((String)equipment.renderArrowInfo()).func_230532_e_();
            arrowInfo.func_230530_a_(arrowInfo.func_150256_b().func_240719_a_(ClientUtils.UNICODE));
            Objects.requireNonNull(mc.field_71466_p);
            float fontHeight = (9 + 7) * i;
            float infoXOffset = right ? (float)(mc.func_228018_at_().func_198107_o() - mc.field_71466_p.func_78256_a(info)) - 20.0625f : (float)baseXOffset + 18.0625f;
            float infoYOffset = (float)(baseYOffset + 4) + fontHeight;
            float arrowXOffset = right ? (float)(mc.func_228018_at_().func_198107_o() - mc.field_71466_p.func_238414_a_((ITextProperties)arrowInfo)) - 2.0625f : (float)baseXOffset + 8.0625f;
            float arrowYOffset = (float)(baseYOffset + 8) + fontHeight;
            EquipmentOverlay.renderItem(itemStack, baseXOffset, equipmentYOffset);
            if (!StringUtils.func_151246_b((String)info)) {
                mc.field_71466_p.func_238405_a_(matrixStack, info, infoXOffset, infoYOffset, ColorUtils.rgbToDecimal((String)IndicatiaSettings.INSTANCE.equipmentStatusColor));
            }
            if (!StringUtils.func_151246_b((String)arrowInfo.getString())) {
                RenderSystem.disableDepthTest();
                mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)arrowInfo, arrowXOffset, arrowYOffset, ColorUtils.rgbToDecimal((String)IndicatiaSettings.INSTANCE.arrowCountColor));
                RenderSystem.enableDepthTest();
            }
            ++i;
        }
    }

    public static void renderHotbarEquippedItems(Minecraft mc, MatrixStack matrixStack) {
        ArrayList equippedLists = Lists.newArrayList();
        ItemStack mainhandStack = mc.field_71439_g.func_184614_ca();
        ItemStack offhandStack = mc.field_71439_g.func_184592_cb();
        int iLeft = 0;
        int iRight = 0;
        if (IndicatiaSettings.INSTANCE.equipmentArmorItems) {
            int i;
            for (i = 2; i <= 3; ++i) {
                equippedLists.add(new HotbarEquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), HotbarEquipmentOverlay.Side.LEFT));
            }
            for (i = 0; i <= 1; ++i) {
                equippedLists.add(new HotbarEquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), HotbarEquipmentOverlay.Side.RIGHT));
            }
        }
        if (IndicatiaSettings.INSTANCE.equipmentHandItems) {
            equippedLists.add(new HotbarEquipmentOverlay(mainhandStack, HotbarEquipmentOverlay.Side.LEFT));
            equippedLists.add(new HotbarEquipmentOverlay(offhandStack, HotbarEquipmentOverlay.Side.RIGHT));
        }
        for (HotbarEquipmentOverlay equipment : equippedLists) {
            int arrowYOffset;
            float arrowXOffset;
            int infoYOffset;
            float infoXOffset;
            int armorYOffset;
            int baseXOffset;
            ItemStack itemStack = equipment.getItemStack();
            String info = equipment.renderInfo();
            IFormattableTextComponent arrowInfo = TextComponentUtils.component((String)equipment.renderArrowInfo()).func_230532_e_();
            arrowInfo.func_230530_a_(arrowInfo.func_150256_b().func_240719_a_(ClientUtils.UNICODE));
            if (itemStack.func_190926_b()) continue;
            if (equipment.getSide() == HotbarEquipmentOverlay.Side.LEFT) {
                baseXOffset = mc.func_228018_at_().func_198107_o() / 2 - 111;
                armorYOffset = mc.func_228018_at_().func_198087_p() - 16 * iLeft - 40;
                infoXOffset = mc.func_228018_at_().func_198107_o() / 2 - 114 - mc.field_71466_p.func_78256_a(info);
                infoYOffset = mc.func_228018_at_().func_198087_p() - 16 * iLeft - 36;
                EquipmentOverlay.renderItem(itemStack, baseXOffset, armorYOffset);
                if (!StringUtils.func_151246_b((String)info)) {
                    mc.field_71466_p.func_238405_a_(matrixStack, info, infoXOffset, (float)infoYOffset, ColorUtils.rgbToDecimal((String)IndicatiaSettings.INSTANCE.equipmentStatusColor));
                }
                if (!StringUtils.func_151246_b((String)arrowInfo.getString())) {
                    arrowXOffset = mc.func_228018_at_().func_198107_o() / 2 - 104;
                    arrowYOffset = mc.func_228018_at_().func_198087_p() - 16 * iLeft - 32;
                    RenderSystem.disableDepthTest();
                    mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)arrowInfo, arrowXOffset, (float)arrowYOffset, ColorUtils.rgbToDecimal((String)IndicatiaSettings.INSTANCE.arrowCountColor));
                    RenderSystem.enableDepthTest();
                }
                ++iLeft;
                continue;
            }
            baseXOffset = mc.func_228018_at_().func_198107_o() / 2 + 95;
            armorYOffset = mc.func_228018_at_().func_198087_p() - 16 * iRight - 40;
            infoXOffset = mc.func_228018_at_().func_198107_o() / 2 + 114;
            infoYOffset = mc.func_228018_at_().func_198087_p() - 16 * iRight - 36;
            EquipmentOverlay.renderItem(itemStack, baseXOffset, armorYOffset);
            if (!StringUtils.func_151246_b((String)info)) {
                mc.field_71466_p.func_238405_a_(matrixStack, info, infoXOffset, (float)infoYOffset, ColorUtils.rgbToDecimal((String)IndicatiaSettings.INSTANCE.equipmentStatusColor));
            }
            if (!StringUtils.func_151246_b((String)arrowInfo.getString())) {
                arrowXOffset = mc.func_228018_at_().func_198107_o() / 2 + 112 - mc.field_71466_p.func_238414_a_((ITextProperties)arrowInfo);
                arrowYOffset = mc.func_228018_at_().func_198087_p() - 16 * iRight - 32;
                RenderSystem.disableDepthTest();
                mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)arrowInfo, arrowXOffset, (float)arrowYOffset, ColorUtils.rgbToDecimal((String)IndicatiaSettings.INSTANCE.arrowCountColor));
                RenderSystem.enableDepthTest();
            }
            ++iRight;
        }
    }

    private static int getTotalWidth(List<HorizontalEquipmentOverlay> equippedLists) {
        int width = 0;
        for (HorizontalEquipmentOverlay equipment : equippedLists) {
            ItemStack itemStack = equipment.getItemStack();
            if (itemStack.func_190926_b()) continue;
            width += equipment.getWidth();
        }
        return width;
    }
}

