/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.hud;

import com.google.common.collect.Lists;
import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.indicatia.utils.hud.InfoOverlay;
import com.stevekung.stevekungslib.utils.LangUtils;
import com.stevekung.stevekungslib.utils.ModDecimalFormat;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class InfoOverlays {
    public static InfoOverlay OVERALL_TPS = InfoOverlay.empty();
    public static InfoOverlay OVERWORLD_TPS = InfoOverlay.empty();
    public static InfoOverlay TPS = InfoOverlay.empty();
    public static final List<InfoOverlay> ALL_TPS = Lists.newArrayList();
    private static final ModDecimalFormat TPS_FORMAT = new ModDecimalFormat("########0.00");

    public static InfoOverlay getDirection(Minecraft mc) {
        String direction;
        String coord;
        int facing;
        Entity entity = mc.func_175606_aa();
        Direction coordDirection = entity.func_174811_aO();
        int yaw = (int)entity.field_70177_z + 22;
        if ((yaw %= 360) < 0) {
            yaw += 360;
        }
        if ((facing = yaw / 45) < 0) {
            facing = 7;
        }
        switch (coordDirection) {
            default: {
                coord = "-Z";
                break;
            }
            case SOUTH: {
                coord = "+Z";
                break;
            }
            case WEST: {
                coord = "-X";
                break;
            }
            case EAST: {
                coord = "+X";
            }
        }
        switch (facing) {
            case 0: {
                direction = "hud.direction.south";
                break;
            }
            case 1: {
                direction = "hud.direction.south_west";
                break;
            }
            case 2: {
                direction = "hud.direction.west";
                break;
            }
            case 3: {
                direction = "hud.direction.north_west";
                break;
            }
            default: {
                direction = "hud.direction.north";
                break;
            }
            case 5: {
                direction = "hud.direction.north_east";
                break;
            }
            case 6: {
                direction = "hud.direction.east";
                break;
            }
            case 7: {
                direction = "hud.direction.south_east";
            }
        }
        direction = LangUtils.translateString((String)direction);
        direction = direction + " (" + coord + ")";
        return new InfoOverlay("hud.direction", direction, IndicatiaSettings.INSTANCE.directionColor, IndicatiaSettings.INSTANCE.directionValueColor, InfoOverlay.Position.LEFT);
    }

    public static void getTPS(MinecraftServer server) {
        double overallTPS = (double)InfoOverlays.mean(server.field_71311_j) * 1.0E-6;
        double overworldTPS = (double)InfoOverlays.mean(server.getTickTime(World.field_234918_g_)) * 1.0E-6;
        double tps = Math.min(1000.0 / overallTPS, 20.0);
        ALL_TPS.clear();
        OVERALL_TPS = new InfoOverlay("Overall TPS", TPS_FORMAT.format(overallTPS), IndicatiaSettings.INSTANCE.tpsColor, IndicatiaSettings.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT);
        if (IndicatiaSettings.INSTANCE.tpsAllDims) {
            OVERWORLD_TPS = InfoOverlay.empty();
            for (ServerWorld world : server.func_212370_w()) {
                long[] values = server.getTickTime(world.func_234923_W_());
                String dimensionName = world.func_234923_W_().func_240901_a_().toString();
                if (values == null) continue;
                double dimensionTPS = (double)InfoOverlays.mean(values) * 1.0E-6;
                ALL_TPS.add(new InfoOverlay("Dimension " + dimensionName, TPS_FORMAT.format(dimensionTPS), IndicatiaSettings.INSTANCE.tpsColor, IndicatiaSettings.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT));
            }
        } else {
            OVERWORLD_TPS = new InfoOverlay("Overworld TPS", TPS_FORMAT.format(overworldTPS), IndicatiaSettings.INSTANCE.tpsColor, IndicatiaSettings.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT);
        }
        TPS = new InfoOverlay("TPS", TPS_FORMAT.format(tps), IndicatiaSettings.INSTANCE.tpsColor, IndicatiaSettings.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT);
    }

    public static InfoOverlay getRealWorldTime() {
        Date date = new Date();
        String dateIns = DateFormat.getDateInstance(2, Locale.getDefault()).format(date);
        String timeIns = DateFormat.getTimeInstance(2, Locale.getDefault()).format(date);
        return new InfoOverlay("hud.real_time", dateIns + " " + timeIns, IndicatiaSettings.INSTANCE.realTimeColor, IndicatiaSettings.INSTANCE.realTimeValueColor, InfoOverlay.Position.RIGHT);
    }

    public static InfoOverlay getGameTime(Minecraft mc) {
        return InfoOverlays.getVanillaGameTime(mc.field_71441_e.func_72820_D() % 24000L);
    }

    private static InfoOverlay getVanillaGameTime(long worldTicks) {
        StringBuilder builder = new StringBuilder();
        int hours = (int)((worldTicks / 1000L + 6L) % 24L);
        int minutes = (int)(60L * (worldTicks % 1000L) / 1000L);
        if (hours <= 9) {
            builder.append(0);
        }
        builder.append(hours);
        builder.append(":");
        if (minutes <= 9) {
            builder.append(0);
        }
        builder.append(minutes);
        builder.append(" " + (hours >= 12 ? "PM" : "AM"));
        return new InfoOverlay("hud.time", builder.toString(), IndicatiaSettings.INSTANCE.gameTimeColor, IndicatiaSettings.INSTANCE.gameTimeValueColor, InfoOverlay.Position.RIGHT);
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }
}

