/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.hud;

import com.stevekung.indicatia.config.IndicatiaSettings;
import com.stevekung.indicatia.event.IndicatiaEventHandler;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class InfoUtils {
    public static final InfoUtils INSTANCE = new InfoUtils();
    private final Minecraft mc = Minecraft.func_71410_x();

    private InfoUtils() {
    }

    public int getPing() {
        NetworkPlayerInfo info = this.mc.func_147114_u().func_175102_a(this.mc.field_71439_g.func_110124_au());
        if (info != null) {
            if (info.func_178853_c() > 0) {
                return info.func_178853_c();
            }
            return IndicatiaEventHandler.currentServerPing;
        }
        return IndicatiaEventHandler.currentServerPing;
    }

    public String getResponseTimeColor(int responseTime) {
        if (responseTime >= 200 && responseTime < 300) {
            return IndicatiaSettings.INSTANCE.ping200And300Color;
        }
        if (responseTime >= 300 && responseTime < 500) {
            return IndicatiaSettings.INSTANCE.ping300And500Color;
        }
        if (responseTime >= 500) {
            return IndicatiaSettings.INSTANCE.pingMax500Color;
        }
        return IndicatiaSettings.INSTANCE.pingValueColor;
    }

    public boolean isHypixel() {
        ServerData server = this.mc.func_147104_D();
        return server != null && server.field_78845_b.contains("hypixel");
    }

    public String getMoonPhase(Minecraft mc) {
        String status;
        int[] moonPhaseFactors = new int[]{4, 3, 2, 1, 0, -1, -2, -3};
        switch (moonPhaseFactors[mc.field_71441_e.func_230315_m_().func_236035_c_(mc.field_71441_e.func_72820_D())]) {
            default: {
                status = "hud.moon_phase.full_moon";
                break;
            }
            case 3: {
                status = "hud.moon_phase.waning_gibbous";
                break;
            }
            case 2: {
                status = "hud.moon_phase.last_quarter";
                break;
            }
            case 1: {
                status = "hud.moon_phase.waning_crescent";
                break;
            }
            case 0: {
                status = "hud.moon_phase.new_moon";
                break;
            }
            case -1: {
                status = "hud.moon_phase.waxing_crescent";
                break;
            }
            case -2: {
                status = "hud.moon_phase.first_quarter";
                break;
            }
            case -3: {
                status = "hud.moon_phase.waxing_gibbous";
            }
        }
        return status;
    }

    public boolean isSlimeChunk(BlockPos pos) {
        int z;
        int x = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        Random rand = new Random(IndicatiaSettings.INSTANCE.slimeChunkSeed + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)((z = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16)) * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL);
        return rand.nextInt(10) == 0;
    }
}

