/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.utils.hud;

import com.stevekung.stevekungslib.utils.ColorUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class InfoOverlay {
    private String title;
    private String value;
    private String titleColor;
    private String valueColor;
    private Position pos;
    private boolean isEmpty;

    public InfoOverlay(String title, String value, String titleColor, String valueColor, Position pos) {
        this.title = title;
        this.value = value;
        this.titleColor = titleColor;
        this.valueColor = valueColor;
        this.pos = pos;
    }

    private InfoOverlay() {
        this.isEmpty = true;
    }

    public String getTitle() {
        return this.title;
    }

    public String getValue() {
        return this.value;
    }

    public String getTitleColor() {
        return this.titleColor;
    }

    public String getValueColor() {
        return this.valueColor;
    }

    public Position getPos() {
        return this.pos;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public IFormattableTextComponent toFormatted() {
        IFormattableTextComponent formatted = StringTextComponent.field_240750_d_.func_230532_e_();
        IFormattableTextComponent title = LangUtils.translate((String)this.title).func_230532_e_();
        formatted.func_230529_a_((ITextComponent)title.func_230530_a_(title.func_150256_b().func_240718_a_(Color.func_240743_a_((int)ColorUtils.rgbToDecimal((String)this.titleColor)))).func_240702_b_(": "));
        IFormattableTextComponent value = LangUtils.translate((String)this.value).func_230532_e_();
        formatted.func_230529_a_((ITextComponent)value.func_230530_a_(value.func_150256_b().func_240718_a_(Color.func_240743_a_((int)ColorUtils.rgbToDecimal((String)this.valueColor)))));
        return this.isEmpty ? StringTextComponent.field_240750_d_.func_230532_e_() : formatted;
    }

    public static InfoOverlay empty() {
        return new InfoOverlay();
    }

    public static enum Position {
        LEFT,
        RIGHT;

    }
}

