/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.data;

import net.minecraft.block.Block;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class BlockStateProviderBase
extends BlockStateProvider {
    public BlockStateProviderBase(DataGenerator generator, String modid, ExistingFileHelper helper) {
        super(generator, modid, helper);
    }

    protected void simpleCross(Block block) {
        this.simpleCross(block, this.toString(block));
    }

    protected void simpleCross(Block block, String name) {
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross(name, this.getBlockTexture(name)))});
    }

    protected void simpleDoublePlant(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross(this.toString(block) + "_bottom", this.getBlockTexture(this.toString(block) + "_bottom")))}).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross(this.toString(block) + "_top", this.getBlockTexture(this.toString(block) + "_top")))});
    }

    protected void simpleFluid(FlowingFluidBlock block) {
        this.getVariantBuilder((Block)block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder(this.toString((Block)block))).texture("particle", "minecraft:" + block.getFluid().getAttributes().getStillTexture().func_110623_a()))});
    }

    protected void simpleTorch(Block block, Block wallBlock) {
        this.simpleBlock(block, (ModelFile)this.models().torch(this.toString(block), this.modLoc("block/" + this.toString(block))));
        this.horizontalBlock(wallBlock, (ModelFile)this.models().torchWall(this.toString(wallBlock), this.modLoc("block/" + this.toString(block))), 90);
    }

    protected void simpleCake(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int slice = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208173_Z);
            String model = slice > 0 ? this.toString(block) + "_slice" + slice : this.toString(block);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + model))).build();
        });
    }

    protected String toString(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    protected ResourceLocation getBlockTexture(String name) {
        return this.modLoc("block/" + name);
    }

    protected ResourceLocation getGeneratedModel(Block block) {
        return ((BlockModelBuilder)this.models().generatedModels.get(this.modLoc("block/" + this.toString(block)))).getLocation();
    }
}

