/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.mixin.client.entity.player;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.stevekung.stevekungslib.utils.client.command.ClientCommands;
import com.stevekung.stevekungslib.utils.client.command.IClientSuggestionProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.command.CommandException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayerEntity.class})
public class MixinClientPlayerEntity {
    private final ClientPlayerEntity that = (ClientPlayerEntity)this;
    @Shadow
    @Final
    protected Minecraft field_71159_c;

    @Inject(method={"sendChatMessage(Ljava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendChatMessage(String message, CallbackInfo info) {
        if (message.length() < 2 || !message.startsWith("/")) {
            return;
        }
        if (!ClientCommands.hasCommand(message.substring(1).split(" ")[0])) {
            return;
        }
        boolean cancel = false;
        try {
            int result = ClientCommands.execute(message.substring(1), (IClientSuggestionProvider)new ClientSuggestionProvider(this.that.field_71174_a, this.field_71159_c));
            if (result != 0) {
                cancel = true;
            }
        }
        catch (CommandException e) {
            this.that.func_146105_b((ITextComponent)e.func_197003_a().func_230532_e_().func_240699_a_(TextFormatting.RED), false);
            cancel = true;
        }
        catch (CommandSyntaxException e) {
            this.that.func_146105_b((ITextComponent)new StringTextComponent(e.getContext()).func_240699_a_(TextFormatting.RED), false);
            cancel = true;
        }
        catch (Exception e) {
            this.that.func_146105_b((ITextComponent)new TranslationTextComponent("command.failed").func_240699_a_(TextFormatting.RED), false);
            cancel = true;
        }
        if (cancel) {
            info.cancel();
        }
    }
}

