/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.stevekung.stevekungslib.utils.TextComponentUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.IItemProvider;

public class ItemUtils {
    public static ItemStack getSkullItemStack(String skullId, String skullValue) {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196184_dx);
        return ItemUtils.setSkullSkin(itemStack, skullId, skullValue);
    }

    public static ItemStack setSkullSkin(ItemStack itemStack, String skullId, String skullValue) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT properties = new CompoundNBT();
        properties.func_74783_a("Id", ItemUtils.uuidToIntArray(skullId));
        CompoundNBT texture = new CompoundNBT();
        ListNBT list = new ListNBT();
        CompoundNBT value = new CompoundNBT();
        value.func_74778_a("Value", ItemUtils.toSkullURL(skullValue));
        list.add((Object)value);
        texture.func_218657_a("textures", (INBT)list);
        properties.func_218657_a("Properties", (INBT)texture);
        compound.func_218657_a("SkullOwner", (INBT)properties);
        itemStack.func_77982_d(compound);
        if (!itemStack.func_77942_o()) {
            compound.func_218657_a("SkullOwner", (INBT)properties);
            itemStack.func_77982_d(compound);
        } else {
            itemStack.func_77978_p().func_218657_a("SkullOwner", (INBT)properties);
        }
        return itemStack;
    }

    public static ItemStack getPlayerHead(String name) {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196184_dx);
        CompoundNBT compound = new CompoundNBT();
        GameProfile profile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, name));
        compound.func_82580_o("SkullOwner");
        compound.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)profile));
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    public static int[] uuidToIntArray(String id) {
        UUID uuid = UUID.fromString(id);
        long uuidMost = uuid.getMostSignificantBits();
        long uuidLeast = uuid.getLeastSignificantBits();
        return new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast};
    }

    public static String decodeTextureURL(String source) {
        JsonObject obj = new JsonParser().parse(new String(Base64.getDecoder().decode(source))).getAsJsonObject();
        String textureurl = obj.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString();
        return textureurl.substring(textureurl.lastIndexOf("/") + 1);
    }

    public static String toSkullURL(String url) {
        JsonObject skin = new JsonObject();
        skin.addProperty("url", "http://textures.minecraft.net/texture/" + url);
        JsonObject textures = new JsonObject();
        textures.add("SKIN", (JsonElement)skin);
        JsonObject root = new JsonObject();
        root.add("textures", (JsonElement)textures);
        return Base64.getEncoder().encodeToString(TextComponentUtils.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }
}

