/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class LoggerBase {
    private final Logger log;
    private final Logger logDebug;
    private static final Marker INFO = MarkerManager.getMarker((String)"INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"ERROR");
    private static final Marker WARNING = MarkerManager.getMarker((String)"WARNING");
    private static final Marker DEBUG = MarkerManager.getMarker((String)"DEBUG");
    private final String modName;
    private boolean debug;

    public LoggerBase(String modName) {
        this.modName = modName;
        this.log = LogManager.getLogger((String)this.modName);
        this.logDebug = LogManager.getLogger((String)(this.modName + " Debug"));
    }

    public void info(String message) {
        this.log.info(INFO, message);
    }

    public void error(String message) {
        this.log.error(ERROR, message);
    }

    public void warning(String message) {
        this.log.warn(WARNING, message);
    }

    public void debug(String message) {
        if (this.debug) {
            this.logDebug.info(DEBUG, message);
        }
    }

    public void info(String message, Object ... obj) {
        this.log.info(INFO, message, obj);
    }

    public void error(String message, Object ... obj) {
        this.log.error(ERROR, message, obj);
    }

    public void warning(String message, Object ... obj) {
        this.log.warn(WARNING, message, obj);
    }

    public void debug(String message, Object ... obj) {
        if (this.debug) {
            this.logDebug.info(DEBUG, message, obj);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

