/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextComponentUtils {
    public static final Gson GSON = new Gson();
    private static final Gson GSON_BUILDER = new GsonBuilder().setPrettyPrinting().create();

    public static StringTextComponent component(String text) {
        return new StringTextComponent(text);
    }

    public static String componentString(String text) {
        return TextComponentUtils.component(text).getString();
    }

    public static IFormattableTextComponent formatted(String text) {
        return TextComponentUtils.component(text).func_230532_e_();
    }

    public static String formattedString(String text) {
        return TextComponentUtils.formatted(text).getString();
    }

    public static IFormattableTextComponent formatted(String text, TextFormatting ... format) {
        return TextComponentUtils.formatted(text).func_240701_a_(format);
    }

    public static IFormattableTextComponent formatted(String text, String hex) {
        IFormattableTextComponent component = TextComponentUtils.formatted(text);
        return component.func_230530_a_(component.func_150256_b().func_240718_a_(Color.func_240745_a_((String)hex)));
    }

    public static IFormattableTextComponent formatted(String text, int color) {
        IFormattableTextComponent component = TextComponentUtils.formatted(text);
        return component.func_230530_a_(component.func_150256_b().func_240718_a_(Color.func_240743_a_((int)color)));
    }

    public static IFormattableTextComponent formatted(String text, String hex, Style style) {
        IFormattableTextComponent component = TextComponentUtils.formatted(text);
        return component.func_230530_a_(style.func_240718_a_(Color.func_240745_a_((String)hex)));
    }

    public static IFormattableTextComponent formatted(String text, int color, Style style) {
        IFormattableTextComponent component = TextComponentUtils.formatted(text);
        return component.func_230530_a_(style.func_240718_a_(Color.func_240743_a_((int)color)));
    }

    public static String formattedString(String text, TextFormatting ... format) {
        return TextComponentUtils.formatted(text, format).getString();
    }

    public static String formattedString(String text, String hex) {
        return TextComponentUtils.formatted(text, hex).getString();
    }

    public static String formattedString(String text, int color) {
        return TextComponentUtils.formatted(text, color).getString();
    }

    public static String fromJson(ITextComponent rawJson) {
        return ITextComponent.Serializer.func_240643_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)rawJson)).getString();
    }

    public static IFormattableTextComponent fromJson(String rawJson) {
        return ITextComponent.Serializer.func_240643_a_((String)rawJson);
    }

    public static String fromJsonUnformatted(String rawJson) {
        return TextFormatting.func_110646_a((String)TextComponentUtils.fromJson(rawJson).getString());
    }

    public static String toJson(String text) {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)TextComponentUtils.component(text));
    }

    public static void toJson(Object src, Appendable writer) {
        if (src != null) {
            TextComponentUtils.toJson(src, src.getClass(), writer);
        } else {
            TextComponentUtils.toJson(JsonNull.INSTANCE, writer);
        }
    }

    private static void toJson(Object src, Type typeOfSrc, Appendable writer) {
        try {
            JsonWriter jsonWriter = TextComponentUtils.newJsonWriter(Streams.writerForAppendable((Appendable)writer));
            GSON_BUILDER.toJson(src, typeOfSrc, jsonWriter);
        }
        catch (JsonIOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    private static JsonWriter newJsonWriter(Writer writer) {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setIndent("    ");
        jsonWriter.setSerializeNulls(GSON_BUILDER.serializeNulls());
        return jsonWriter;
    }
}

