/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils.config;

import com.stevekung.stevekungslib.utils.config.AbstractSettings;
import com.stevekung.stevekungslib.utils.config.Settings;
import com.stevekung.stevekungslib.utils.config.SettingsSlider;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class SliderPercentageSettings<T extends Settings>
extends AbstractSettings<T> {
    protected final float stepSize;
    protected final double minValue;
    protected double maxValue;
    private final Function<T, Double> getter;
    private final BiConsumer<T, Double> setter;
    private final BiFunction<T, SliderPercentageSettings<T>, ITextComponent> getDisplayStringFunc;

    public SliderPercentageSettings(String translationKey, double minValue, double maxValue, float stepSize, Function<T, Double> getter, BiConsumer<T, Double> setter, BiFunction<T, SliderPercentageSettings<T>, ITextComponent> getDisplayString) {
        super(translationKey);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = stepSize;
        this.getter = getter;
        this.setter = setter;
        this.getDisplayStringFunc = getDisplayString;
    }

    @Override
    public Widget createWidget(T settings, int x, int y, int width) {
        return new SettingsSlider<T>(settings, x, y, width, 20, this);
    }

    public double normalizeValue(double value) {
        return MathHelper.func_151237_a((double)((this.snapToStepClamp(value) - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
    }

    public double denormalizeValue(double value) {
        return this.snapToStepClamp(MathHelper.func_219803_d((double)MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue));
    }

    private double snapToStepClamp(double value) {
        if (this.stepSize > 0.0f) {
            value = this.stepSize * (float)Math.round(value / (double)this.stepSize);
        }
        return MathHelper.func_151237_a((double)value, (double)this.minValue, (double)this.maxValue);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
    }

    public void set(T settings, double value) {
        this.setter.accept(settings, value);
    }

    public double get(T settings) {
        return this.getter.apply(settings);
    }

    public ITextComponent getMessage(T settings) {
        return this.getDisplayStringFunc.apply(settings, this);
    }
}

