/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockTileEntityConnected;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.tileentity.TileEntityBatteryBank;
import cassiokf.industrialrenewal.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BlockBatteryBank
extends BlockTileEntityConnected<TileEntityBatteryBank> {
    public BlockBatteryBank(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"info.industrialrenewal.capacity", (Object[])new Object[0]) + ": " + Utils.formatEnergyString(IRConfig.MainConfig.Main.batteryBankCapacity));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (hand.equals((Object)EnumHand.MAIN_HAND) && playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b().equals((Object)ModItems.screwDrive) && te instanceof TileEntityBatteryBank) {
            ((TileEntityBatteryBank)te).toggleFacing(facing);
            worldIn.func_184138_a(pos, state, state, 3);
            if (!worldIn.field_72995_K) {
                ItemPowerScrewDrive.playDrillSound(worldIn, pos);
            }
            return true;
        }
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            IExtendedBlockState eState = (IExtendedBlockState)state;
            TileEntityBatteryBank te = (TileEntityBatteryBank)world.func_175625_s(pos);
            if (te != null) {
                return eState.withProperty(SOUTH, (Object)te.isFacingOutput(facing.func_176734_d())).withProperty(NORTH, (Object)te.isFacingOutput(facing)).withProperty(EAST, (Object)te.isFacingOutput(facing.func_176746_e())).withProperty(WEST, (Object)te.isFacingOutput(facing.func_176735_f())).withProperty(UP, (Object)te.isFacingOutput(EnumFacing.UP)).withProperty(DOWN, (Object)te.isFacingOutput(EnumFacing.DOWN));
            }
        }
        return state;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @Nullable
    public TileEntityBatteryBank createTileEntity(World world, IBlockState state) {
        return new TileEntityBatteryBank();
    }
}

