/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockCatwalkGate;
import cassiokf.industrialrenewal.blocks.BlockCatwalkHatch;
import cassiokf.industrialrenewal.blocks.BlockCatwalkLadder;
import cassiokf.industrialrenewal.blocks.BlockCatwalkStair;
import cassiokf.industrialrenewal.blocks.BlockElectricGate;
import cassiokf.industrialrenewal.blocks.abstracts.BlockTileEntity;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorCable;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorLamp;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorPipe;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockIndustrialFloor;
import cassiokf.industrialrenewal.blocks.pipes.BlockEnergyCable;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.tileentity.TileEntityCatWalk;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCatWalk
extends BlockTileEntity<TileEntityCatWalk> {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    protected static final AxisAlignedBB RENDER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1876, 1.0);
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.5, 0.03125);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.96875, 1.0, 1.5, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.03125, 1.5, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.96875, 0.0, 0.0, 1.0, 1.5, 1.0);

    public BlockCatWalk(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            TileEntityCatWalk te;
            Item playerItem = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            if (playerItem.equals((Object)ModItems.screwDrive) && (te = (TileEntityCatWalk)world.func_175625_s(pos)) != null) {
                te.toggleFacing(side);
                if (!world.field_72995_K) {
                    ItemPowerScrewDrive.playDrillSound(world, pos);
                }
                world.func_184138_a(pos, state, state, 2);
            }
            BlockPos posOffset = pos.func_177972_a(player.func_174811_aO());
            IBlockState stateOffset = world.func_180495_p(posOffset);
            if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catWalk)) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catWalkSteel))) {
                if (side == EnumFacing.UP) {
                    if (stateOffset.func_177230_c().func_176200_f((IBlockAccess)world, posOffset)) {
                        world.func_180501_a(pos.func_177972_a(player.func_174811_aO()), BlockCatWalk.func_149634_a((Item)playerItem).func_176223_P(), 3);
                        if (!player.func_184812_l_()) {
                            player.field_71071_by.func_174925_a(playerItem, 0, 1, null);
                        }
                        return true;
                    }
                    return true;
                }
                return false;
            }
            if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catwalkStair)) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catwalkStairSteel))) {
                if (stateOffset.func_177230_c().isAir(stateOffset, (IBlockAccess)world, posOffset)) {
                    world.func_180501_a(posOffset, BlockCatWalk.func_149634_a((Item)playerItem).func_176223_P().func_177226_a((IProperty)BlockCatwalkStair.FACING, (Comparable)player.func_174811_aO()), 3);
                    if (!player.func_184812_l_()) {
                        player.field_71071_by.func_174925_a(playerItem, 0, 1, null);
                    }
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected boolean isValidConnection(IBlockState neighbourState, IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        TileEntityCatWalk te = (TileEntityCatWalk)world.func_175625_s(ownPos);
        if (te != null && te.isFacingBlackListed(neighbourDirection)) {
            return true;
        }
        IBlockState downstate = world.func_180495_p(ownPos.func_177972_a(neighbourDirection).func_177977_b());
        Block nb = neighbourState.func_177230_c();
        if (neighbourDirection != EnumFacing.UP && neighbourDirection != EnumFacing.DOWN) {
            return nb instanceof BlockCatWalk || nb instanceof BlockDoor || nb instanceof BlockElectricGate || nb instanceof BlockStairs && (neighbourState.func_177229_b((IProperty)BlockStairs.field_176309_a) == neighbourDirection || neighbourState.func_177229_b((IProperty)BlockStairs.field_176309_a) == neighbourDirection.func_176734_d()) || downstate.func_177230_c() instanceof BlockStairs && downstate.func_177229_b((IProperty)BlockStairs.field_176309_a) == neighbourDirection.func_176734_d() || nb instanceof BlockCatwalkHatch && neighbourState.func_177229_b((IProperty)BlockCatwalkHatch.FACING) == neighbourDirection || nb instanceof BlockCatwalkGate && neighbourState.func_177229_b((IProperty)BlockCatwalkGate.FACING) == neighbourDirection.func_176734_d() || nb instanceof BlockCatwalkStair && neighbourState.func_177229_b((IProperty)BlockCatwalkStair.FACING) == neighbourDirection || downstate.func_177230_c() instanceof BlockCatwalkStair && downstate.func_177229_b((IProperty)BlockCatwalkStair.FACING) == neighbourDirection.func_176734_d() || downstate.func_177230_c() instanceof BlockCatwalkLadder && downstate.func_177229_b((IProperty)BlockCatwalkLadder.FACING) == neighbourDirection.func_176734_d() || nb instanceof BlockCatwalkLadder && neighbourState.func_177229_b((IProperty)BlockCatwalkLadder.FACING) == neighbourDirection && (Boolean)neighbourState.func_177229_b((IProperty)BlockCatwalkLadder.ACTIVE) == false;
        }
        if (neighbourDirection == EnumFacing.DOWN) {
            return nb instanceof BlockCatwalkLadder || nb instanceof BlockLadder || nb instanceof BlockIndustrialFloor || nb instanceof BlockFloorLamp || nb instanceof BlockFloorCable || nb instanceof BlockFloorPipe || nb instanceof BlockCatWalk;
        }
        return !(neighbourState.func_177230_c() instanceof BlockEnergyCable);
    }

    private boolean canConnectTo(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        return !this.isValidConnection(neighbourState, worldIn, ownPos, neighbourDirection);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        if (this.isConnected(state, EnumFacing.DOWN)) {
            BlockCatWalk.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        }
        if (this.isConnected(state, EnumFacing.NORTH)) {
            BlockCatWalk.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (this.isConnected(state, EnumFacing.SOUTH)) {
            BlockCatWalk.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (this.isConnected(state, EnumFacing.WEST)) {
            BlockCatWalk.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
        if (this.isConnected(state, EnumFacing.EAST)) {
            BlockCatWalk.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return RENDER_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @Nullable
    public TileEntityCatWalk createTileEntity(World world, IBlockState state) {
        return new TileEntityCatWalk();
    }
}

