/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.ChunkManagerCallback;
import cassiokf.industrialrenewal.tileentity.TileEntityChunkLoader;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class BlockChunkLoader
extends BlockHorizontalFacing {
    public static final PropertyBool MASTER = PropertyBool.func_177716_a((String)"master");
    public static final PropertyBool WORKING = PropertyBool.func_177716_a((String)"working");

    public BlockChunkLoader(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
    }

    private static void activateChunkLoader(World worldIn, BlockPos pos, EntityPlayer placer) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestPlayerTicket((Object)IndustrialRenewal.instance, (String)placer.func_70005_c_(), (World)worldIn, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            placer.func_146105_b((ITextComponent)new TextComponentString("Could not request any more chunk loading tickets"), true);
            return;
        }
        NBTTagCompound modData = ticket.getModData();
        modData.func_74782_a("blockPosition", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        modData.func_74768_a("size", IRConfig.MainConfig.Main.chunkLoaderWidth);
        ChunkManagerCallback.activateTicket(worldIn, ticket);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!(placer instanceof EntityPlayer) || !((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue() || worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityChunkLoader) {
            ((TileEntityChunkLoader)te).setMaster(true);
        }
        BlockChunkLoader.activateChunkLoader(worldIn, pos, (EntityPlayer)placer);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityChunkLoader)) {
            return false;
        }
        boolean success = false;
        if (((TileEntityChunkLoader)tileEntity).isExpired() || !((TileEntityChunkLoader)tileEntity).hasTicket(playerIn)) {
            BlockChunkLoader.activateChunkLoader(worldIn, tileEntity.func_174877_v(), playerIn);
            success = true;
        }
        return success;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            TileEntity tileEntity;
            if (this.IsLoader(worldIn, pos.func_177984_a())) {
                worldIn.func_175698_g(pos.func_177984_a());
            }
            if ((tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityChunkLoader) {
                ((TileEntityChunkLoader)tileEntity).expireAllTickets();
            }
        } else if (this.IsLoader(worldIn, pos.func_177977_b())) {
            worldIn.func_175698_g(pos.func_177977_b());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private boolean IsLoader(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockChunkLoader;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)MASTER) != false && te instanceof TileEntityChunkLoader && ((TileEntityChunkLoader)te).isActive()));
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MASTER, WORKING});
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        int directionIndex = meta;
        if (meta > 3) {
            directionIndex -= 4;
        }
        boolean index = true;
        if (meta > 3) {
            index = false;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)directionIndex)).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(index));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (!((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            i += 4;
        }
        return i;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityChunkLoader)) {
            return false;
        }
        tileEntity.func_145842_c(id, param);
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntityChunkLoader createTileEntity(World world, IBlockState state) {
        return new TileEntityChunkLoader();
    }
}

