/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockRoof;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFluorescent
extends BlockBase {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);

    public BlockFluorescent(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.func_149715_a(1.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected boolean isValidConnection(IBlockState ownState, IBlockState neighbourState, IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        Block nb = neighbourState.func_177230_c();
        if (neighbourDirection != EnumFacing.UP) {
            return nb instanceof BlockFluorescent;
        }
        return !(nb instanceof BlockRoof) || ownPos.func_177952_p() % 2 == 0;
    }

    private boolean canConnectTo(IBlockState ownState, IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        return this.isValidConnection(ownState, neighbourState, worldIn, ownPos, neighbourDirection);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        BlockFluorescent.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        if (this.isConnected(actualState, EnumFacing.UP)) {
            BlockFluorescent.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BASE_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

