/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.TileEntityRecordPlayer;
import cassiokf.industrialrenewal.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNote;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockRecordPlayer
extends BlockHorizontalFacing {
    public static final PropertyBool DOWNNOTEBLOCK = PropertyBool.func_177716_a((String)"downnoteblock");
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockRecordPlayer(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151575_d);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)DOWNNOTEBLOCK, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.OpenGUI(world, pos, player);
        }
        return true;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityRecordPlayer te = (TileEntityRecordPlayer)world.func_175625_s(pos);
        assert (te != null);
        IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        assert (inventory != null);
        Utils.dropInventoryItems(world, pos, inventory);
        super.func_180663_b(world, pos, state);
    }

    private void OpenGUI(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private boolean isDownBlockaNoteBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockNote;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)DOWNNOTEBLOCK, (Comparable)Boolean.valueOf(this.isDownBlockaNoteBlock(world, pos)));
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)DOWNNOTEBLOCK, (Comparable)Boolean.valueOf(this.isDownBlockaNoteBlock((IBlockAccess)worldIn, pos)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DOWNNOTEBLOCK});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BASE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntityRecordPlayer createTileEntity(World world, IBlockState state) {
        return new TileEntityRecordPlayer();
    }
}

