/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockCatwalkLadder;
import cassiokf.industrialrenewal.blocks.BlockColumn;
import cassiokf.industrialrenewal.blocks.BlockPillar;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockRoof
extends BlockHorizontalFacing {
    public static final IUnlistedProperty<Boolean> SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"south"));
    public static final IUnlistedProperty<Boolean> NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"north"));
    public static final IUnlistedProperty<Boolean> EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"east"));
    public static final IUnlistedProperty<Boolean> WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"west"));
    public static final IUnlistedProperty<Boolean> DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"down"));
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB BOT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockRoof(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.func_149713_g(255);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FACING};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{SOUTH, NORTH, EAST, WEST, DOWN};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    private Boolean isEven(BlockPos pos, boolean baseOnX) {
        int number = pos.func_177952_p();
        if (baseOnX) {
            number = pos.func_177958_n();
        }
        return number % 2 == 0;
    }

    private boolean canConnectTo(IBlockAccess world, BlockPos ownPos, EnumFacing ownFacing, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = world.func_180495_p(neighbourPos);
        if (neighbourDirection == EnumFacing.DOWN) {
            return neighbourState.func_185917_h() || neighbourState.func_185896_q();
        }
        if (!((neighbourDirection != EnumFacing.EAST && neighbourDirection != EnumFacing.WEST || ownFacing != EnumFacing.SOUTH && ownFacing != EnumFacing.NORTH) && (neighbourDirection != EnumFacing.SOUTH && neighbourDirection != EnumFacing.NORTH || ownFacing != EnumFacing.WEST && ownFacing != EnumFacing.EAST))) {
            IBlockState sState = world.func_180495_p(ownPos.func_177972_a(EnumFacing.SOUTH));
            IBlockState nState = world.func_180495_p(ownPos.func_177972_a(EnumFacing.NORTH));
            Block sBlock = sState.func_177230_c();
            Block nBlock = nState.func_177230_c();
            if ((sBlock instanceof BlockRoof || sBlock instanceof BlockCatwalkLadder || sState.func_185917_h()) && (nBlock instanceof BlockRoof || nBlock instanceof BlockCatwalkLadder || nState.func_185917_h())) {
                boolean invert = ownFacing == EnumFacing.WEST || ownFacing == EnumFacing.EAST;
                Block nb = neighbourState.func_177230_c();
                return this.isEven(ownPos, invert) != false && (nb instanceof BlockRoof || neighbourState.func_185917_h() || nb instanceof BlockPillar || nb instanceof BlockColumn);
            }
        }
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState eState = (IExtendedBlockState)state;
            if (this.canConnectTo(world, pos, EnumFacing.NORTH, EnumFacing.DOWN)) {
                return eState.withProperty(SOUTH, (Object)false).withProperty(NORTH, (Object)false).withProperty(EAST, (Object)false).withProperty(WEST, (Object)false).withProperty(DOWN, (Object)true);
            }
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            return eState.withProperty(SOUTH, (Object)this.canConnectTo(world, pos, facing, facing.func_176734_d())).withProperty(NORTH, (Object)this.canConnectTo(world, pos, facing, facing)).withProperty(EAST, (Object)this.canConnectTo(world, pos, facing, facing.func_176746_e())).withProperty(WEST, (Object)this.canConnectTo(world, pos, facing, facing.func_176735_f())).withProperty(DOWN, (Object)false);
        }
        return state;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockRoof.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BASE_AABB;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

