/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.abstracts;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityToggleableBase;
import cassiokf.industrialrenewal.util.enums.enumproperty.EnumFaceRotation;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockToggleableBase<TE extends TileEntityToggleableBase>
extends BlockHorizontalFacing {
    public static final IProperty<EnumFacing> FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final IProperty<EnumFaceRotation> FACE_ROTATION = PropertyEnum.func_177709_a((String)"face_rotation", EnumFaceRotation.class);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    protected static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);

    public BlockToggleableBase(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = worldIn.func_175640_z(pos);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityToggleableBase && (flag || blockIn.func_176223_P().func_185897_m()) && flag != ((TileEntityToggleableBase)te).powered) {
            ((TileEntityToggleableBase)te).setPowered(flag);
            if (flag != (Boolean)state.func_177229_b((IProperty)ACTIVE)) {
                ((TileEntityToggleableBase)te).setActive(flag);
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(flag)), 3);
            }
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE, FACE_ROTATION});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityToggleableBase te = (TileEntityToggleableBase)world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        te.playSwitchSound();
        boolean active = (Boolean)state.func_177229_b((IProperty)ACTIVE) == false;
        state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
        te.setActive(active);
        world.func_180501_a(pos, state, 3);
        world.func_175685_c(pos, (Block)this, false);
        return true;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        this.rotateFace(world, pos);
        return true;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityToggleableBase tileEntity = this.getTileEntity((IBlockAccess)world, pos);
        this.setFacing((IBlockAccess)world, pos, EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
        tileEntity.func_70296_d();
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        TileEntityToggleableBase tileEntity = this.getTileEntity(world, pos);
        return tileEntity != null ? tileEntity.getFacing() : EnumFacing.SOUTH;
    }

    public EnumFaceRotation getFaceRotation(IBlockAccess world, BlockPos pos) {
        TileEntityToggleableBase tileEntity = this.getTileEntity(world, pos);
        return tileEntity != null ? tileEntity.getFaceRotation() : EnumFaceRotation.UP;
    }

    public void setFacing(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        TileEntityToggleableBase tileEntity = this.getTileEntity(world, pos);
        if (tileEntity != null) {
            tileEntity.setFacing(facing);
        }
    }

    public void setFaceRotation(IBlockAccess world, BlockPos pos, EnumFaceRotation faceRotation) {
        TileEntityToggleableBase tileEntity = this.getTileEntity(world, pos);
        if (tileEntity != null) {
            tileEntity.setFaceRotation(faceRotation);
        }
    }

    private TileEntityToggleableBase getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TileEntityToggleableBase)world.func_175625_s(pos);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(FACING, (Comparable)this.getFacing(worldIn, pos)).func_177226_a(FACE_ROTATION, (Comparable)((Object)this.getFaceRotation(worldIn, pos))).func_177226_a((IProperty)ACTIVE, state.func_177229_b((IProperty)ACTIVE));
    }

    public void rotateFace(World world, BlockPos pos) {
        EnumFaceRotation faceRotation = this.getFaceRotation((IBlockAccess)world, pos);
        this.setFaceRotation((IBlockAccess)world, pos, faceRotation.rotateClockwise());
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public abstract TE createTileEntity(World var1, IBlockState var2);
}

