/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.entity;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.entity.LocomotiveBase;
import cassiokf.industrialrenewal.handlers.SteamBoiler;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.util.Utils;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class EntitySteamLocomotive
extends LocomotiveBase {
    private final SteamBoiler boiler = new SteamBoiler(this, SteamBoiler.BoilerType.Solid, 1){

        @Override
        public void outPutSteam() {
            EntitySteamLocomotive.this.onSteamGenerated();
        }
    }.setWaterTankCapacity(64000);

    public EntitySteamLocomotive(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntitySteamLocomotive(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    public void onLocomotiveUpdate() {
        this.fillBoiler();
        this.boiler.onTick();
    }

    public void onSteamGenerated() {
        if (this.boiler.steamTank.getFluidAmount() > 0) {
            this.moveForward();
            this.boiler.steamTank.drain(20, true);
        }
    }

    private void fillBoiler() {
        if (this.tender == null) {
            return;
        }
        FluidTank tenderTank = this.tender.tank;
        tenderTank.drain(this.boiler.waterTank.fill(tenderTank.drain(1000, false), true), true);
        Utils.moveItemsBetweenInventories((IItemHandler)this.tender.inventory, (IItemHandler)this.boiler.solidFuelInv);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)IndustrialRenewal.instance, 3, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public ItemStack getCartItem() {
        return new ItemStack((Item)ModItems.steamLocomotive);
    }

    @Override
    public float getMaxCouplingDistance(EntityMinecart cart) {
        return 2.0f;
    }

    @Override
    public float getFixedDistance(EntityMinecart cart) {
        return 1.6f;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.boiler.serialize(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.boiler.deserialize(compound);
    }
}

