/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.handlers;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidGenerator {
    public static int energyPerTick = IRConfig.MainConfig.Main.portableGeneratorEnergyPerTick;
    private final TileEntitySync attachedTE;
    public final FluidTank tank;
    public final VoltsEnergyContainer energyStorage;
    private boolean canGenerate;
    private boolean isGenerating;
    private boolean oldRunning;
    private int fuelTime;

    public FluidGenerator(TileEntitySync te) {
        this.tank = new FluidTank(IRConfig.MainConfig.Main.portableGeneratorCapacity){

            public void onContentsChanged() {
                FluidGenerator.this.sync();
            }
        };
        this.energyStorage = new VoltsEnergyContainer(128, 128, energyPerTick){

            @Override
            public void onEnergyChange() {
                FluidGenerator.this.markDirty();
            }

            @Override
            public boolean canExtract() {
                return false;
            }
        };
        this.canGenerate = false;
        this.isGenerating = false;
        this.oldRunning = false;
        this.fuelTime = 0;
        this.attachedTE = te;
    }

    public void onTick() {
        if (this.canGenerate) {
            this.updateLiquidFuel();
            if (this.fuelTime > 0) {
                this.isGenerating = true;
                this.energyStorage.receiveInternally(energyPerTick, false);
                --this.fuelTime;
            } else {
                this.isGenerating = false;
            }
        } else {
            this.isGenerating = false;
        }
        if (this.isGenerating != this.oldRunning) {
            this.oldRunning = this.isGenerating;
            this.sync();
        }
    }

    public void markDirty() {
        this.attachedTE.func_70296_d();
    }

    public void sync() {
        this.attachedTE.sync();
    }

    private void updateLiquidFuel() {
        int fuel;
        if (this.fuelTime > 0) {
            return;
        }
        FluidStack resource = this.tank.getFluid();
        if (resource == null || resource.amount <= 0) {
            return;
        }
        int n = fuel = IRConfig.MainConfig.Main.fluidFuel.get(resource.getFluid().getName()) != null ? IRConfig.MainConfig.Main.fluidFuel.get(resource.getFluid().getName()) : 0;
        if (fuel > 0) {
            int amount = Math.min(1000, resource.amount);
            float norm = Utils.normalizeClamped(amount, 0.0f, 1000.0f);
            this.fuelTime = (int)((float)fuel * norm) * 4;
            this.tank.drainInternal(amount, true);
        }
    }

    public boolean isGenerating() {
        return this.isGenerating;
    }

    public NBTTagCompound saveGenerator(NBTTagCompound compound) {
        compound.func_74768_a("FGenerator", this.fuelTime);
        compound.func_74757_a("running", this.isGenerating);
        compound.func_74757_a("generate", this.canGenerate);
        compound.func_74782_a("energy", (NBTBase)this.energyStorage.serializeNBT());
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    public void loadGenerator(NBTTagCompound compound) {
        this.fuelTime = compound.func_74762_e("FGenerator");
        this.isGenerating = compound.func_74767_n("running");
        this.canGenerate = compound.func_74767_n("generate");
        this.energyStorage.deserializeNBT(compound.func_74775_l("energy"));
        this.tank.readFromNBT(compound.func_74775_l("tank"));
    }

    public void setCanGenerate(boolean value) {
        this.canGenerate = value;
    }

    public void changeCanGenerate() {
        this.canGenerate = !this.canGenerate;
    }
}

