/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.item;

import cassiokf.industrialrenewal.blocks.BlockFireExtinguisher;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.item.ItemBase;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class ItemFireExtinguisher
extends ItemBase {
    public ItemFireExtinguisher(String name, CreativeTabs tab) {
        super(name, tab);
        this.field_77777_bU = 1;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        BlockPos posOffset = pos.func_177972_a(facing);
        if (player.func_70093_af()) {
            if (worldIn.func_175623_d(posOffset) || worldIn.func_180495_p(posOffset).func_177230_c().func_176200_f((IBlockAccess)worldIn, posOffset)) {
                this.playSound(worldIn, pos, "block.metal.place");
                worldIn.func_175656_a(posOffset, ModBlocks.fireExtinguisher.func_176223_P().func_177226_a((IProperty)BlockFireExtinguisher.FACING, (Comparable)player.func_174811_aO()).func_177226_a((IProperty)BlockFireExtinguisher.ONWALL, (Comparable)Boolean.valueOf(facing != EnumFacing.UP)));
                itemstack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        } else if (IRConfig.MainConfig.Main.fireExtinguisherOnNether || player.field_71093_bK != DimensionType.NETHER.func_186068_a()) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            this.add9x9pos(list, pos);
            for (BlockPos bpos : list) {
                worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)bpos.func_177972_a(facing).func_177958_n() + 0.5, (double)bpos.func_177972_a(facing).func_177956_o() + 0.5, (double)bpos.func_177972_a(facing).func_177952_p() + 0.5, 0.0, 1.0, 0.0, new int[0]);
                for (EnumFacing faces : EnumFacing.values()) {
                    IBlockState state = worldIn.func_180495_p(bpos);
                    if (worldIn.func_175719_a(player, bpos, faces)) {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)bpos.func_177958_n() + 0.5, (double)bpos.func_177956_o() + 0.5, (double)bpos.func_177952_p() + 0.5, 0.0, 1.0, 0.0, new int[0]);
                        this.playSound(worldIn, pos, "block.fire.extinguish");
                    }
                    if (state.func_185904_a() == Material.field_151587_i && (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0) {
                        worldIn.func_175656_a(bpos, Blocks.field_150343_Z.func_176223_P());
                    }
                    if (state.func_185904_a() != Material.field_151587_i || (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) <= 0) continue;
                    worldIn.func_175656_a(bpos, Blocks.field_150347_e.func_176223_P());
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private void playSound(World world, BlockPos pos, String resourceLocation) {
        world.func_184133_a(null, pos, (SoundEvent)Objects.requireNonNull(SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(resourceLocation))), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void add9x9pos(ArrayList<BlockPos> list, BlockPos initialPos) {
        list.add(initialPos);
        list.add(initialPos.func_177972_a(EnumFacing.NORTH));
        list.add(initialPos.func_177972_a(EnumFacing.SOUTH));
        list.add(initialPos.func_177972_a(EnumFacing.EAST));
        list.add(initialPos.func_177972_a(EnumFacing.EAST).func_177972_a(EnumFacing.NORTH));
        list.add(initialPos.func_177972_a(EnumFacing.EAST).func_177972_a(EnumFacing.SOUTH));
        list.add(initialPos.func_177972_a(EnumFacing.WEST));
        list.add(initialPos.func_177972_a(EnumFacing.WEST).func_177972_a(EnumFacing.NORTH));
        list.add(initialPos.func_177972_a(EnumFacing.WEST).func_177972_a(EnumFacing.SOUTH));
    }
}

