/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockSmallWindTurbine;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.item.ItemWindBlade;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySmallWindTurbine
extends TileEntitySync
implements ITickable {
    private final VoltsEnergyContainer energyContainer;
    public ItemStackHandler bladeInv = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            return stack.func_77973_b() instanceof ItemWindBlade;
        }

        protected void onContentsChanged(int slot) {
            TileEntitySmallWindTurbine.this.sync();
        }
    };
    private float rotation;
    private float oldRotation;
    private int tickToDamage;
    private EnumFacing blockFacing;
    private final Random random = new Random();

    public TileEntitySmallWindTurbine() {
        this.energyContainer = new VoltsEnergyContainer(32000, 1024, 1024){

            @Override
            public boolean canReceive() {
                return false;
            }
        };
    }

    public void dropAllItems() {
        Utils.dropInventoryItems(this.field_145850_b, this.field_174879_c, this.bladeInv);
    }

    public static int getMaxGeneration() {
        return IRConfig.MainConfig.Main.maxEnergySWindTurbine;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IEnergyStorage downE;
            TileEntity te;
            int energyGen = 0;
            if (this.hasBlade()) {
                energyGen = Math.round((float)TileEntitySmallWindTurbine.getMaxGeneration() * this.getEfficiency());
                if (this.tickToDamage >= 1200 && energyGen > 0) {
                    this.tickToDamage = 0;
                    if (this.bladeInv.getStackInSlot(0).func_96631_a(1, this.random, null)) {
                        this.bladeInv.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                }
                if (this.tickToDamage < 1201) {
                    ++this.tickToDamage;
                }
            }
            if (energyGen > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && (downE = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) != null && downE.canReceive()) {
                downE.receiveEnergy(energyGen, false);
            }
        } else if (this.hasBlade()) {
            this.oldRotation = this.rotation;
            this.rotation += 6.0f * this.getEfficiency();
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.oldRotation -= 360.0f;
            }
        }
    }

    public IItemHandler getBladeHandler() {
        return this.bladeInv;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getOldRotation() {
        return this.oldRotation;
    }

    public double func_145833_n() {
        return super.func_145833_n() * IRConfig.MainConfig.Render.windBladesRenderDistanceMult;
    }

    public boolean hasBlade() {
        return !this.bladeInv.getStackInSlot(0).func_190926_b();
    }

    private float getEfficiency() {
        float weatherModifier = this.field_145850_b.func_72911_I() ? 1.0f : (this.field_145850_b.func_72896_J() ? 0.9f : 0.8f);
        float posMin = -2040.0f;
        float heightModifier = this.field_174879_c.func_177956_o() - 62 <= 0 ? 0.0f : ((float)this.field_174879_c.func_177956_o() - posMin) / (255.0f - posMin);
        heightModifier = MathHelper.func_76131_a((float)heightModifier, (float)0.0f, (float)1.0f);
        return weatherModifier * heightModifier;
    }

    public EnumFacing getBlockFacing() {
        if (this.blockFacing != null) {
            return this.blockFacing;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockSmallWindTurbine) {
            this.blockFacing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontalFacing.FACING);
            return this.blockFacing;
        }
        return EnumFacing.NORTH;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.bladeInv.deserializeNBT(compound.func_74775_l("bladeInv"));
        this.tickToDamage = compound.func_74762_e("damageTick");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("bladeInv", (NBTBase)this.bladeInv.serializeNBT());
        compound.func_74768_a("damageTick", this.tickToDamage);
        return super.func_189515_b(compound);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177963_a(-4.0, -4.0, -4.0), this.field_174879_c.func_177963_a(5.0, 5.0, 5.0));
    }
}

