/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockSolarPanelFrame;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.tileentity.TileEntitySolarPanelBase;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import cassiokf.industrialrenewal.util.MultiBlockHelper;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntitySolarPanelFrame
extends TileEntityMultiBlocksTube<TileEntitySolarPanelFrame> {
    public final VoltsEnergyContainer energyContainer;
    private final Set<TileEntitySolarPanelFrame> panelReady = new HashSet<TileEntitySolarPanelFrame>();
    private final ItemStack panelStack = new ItemStack((Block)ModBlocks.spanel);
    private int tick;
    private EnumFacing blockFacing;
    public boolean panelInv;
    private int energyCanOutput = 0;
    private final int random = new Random().nextInt(10);

    public TileEntitySolarPanelFrame() {
        this.energyContainer = new VoltsEnergyContainer(10240, 0, 10240){

            @Override
            public boolean canReceive() {
                return false;
            }

            @Override
            public boolean canExtract() {
                return false;
            }

            @Override
            public int receiveInternally(int maxReceive, boolean simulate) {
                return TileEntitySolarPanelFrame.this.outputEnergy(maxReceive, simulate);
            }
        };
    }

    @Override
    public void onFirstTick() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkIfIsReady();
            if (this.isMaster()) {
                this.getEnergyFromSun();
            }
        }
    }

    @Override
    public void tick() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isMaster() && this.panelReady.size() > 0 && this.energyCanOutput > 0) {
                this.energyContainer.receiveInternally(this.energyCanOutput, false);
            }
            if (this.tick >= 20 + this.random) {
                this.tick = 0;
                this.checkIfIsReady();
                if (this.isMaster()) {
                    this.getEnergyFromSun();
                }
            }
            ++this.tick;
        }
    }

    private int outputEnergy(int maxReceive, boolean simulate) {
        if (!this.isMaster()) {
            return ((TileEntitySolarPanelFrame)this.getMaster()).outputEnergy(maxReceive, simulate);
        }
        if (this.inUse) {
            return 0;
        }
        if (maxReceive <= 0) {
            return 0;
        }
        this.inUse = true;
        int out = MultiBlockHelper.outputEnergy(this, maxReceive, this.energyContainer.getMaxOutput(), simulate, this.field_145850_b).get(0);
        this.inUse = false;
        return out;
    }

    public double func_145833_n() {
        return super.func_145833_n() * IRConfig.MainConfig.Render.frameSolarPanelRenderMult;
    }

    public void setPanelInv(boolean panelInv) {
        this.panelInv = panelInv;
        this.sync();
    }

    @Override
    public EnumFacing[] getFacesToCheck() {
        return EnumFacing.field_176754_o;
    }

    @Override
    public boolean instanceOf(TileEntity te) {
        return te instanceof TileEntitySolarPanelFrame;
    }

    public Set<TileEntitySolarPanelFrame> getPanelReadySet() {
        return this.panelReady;
    }

    public void checkIfIsReady() {
        if (this.hasPanel() && this.field_145850_b.field_73011_w.func_191066_m() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177972_a(EnumFacing.UP)) && this.field_145850_b.func_175657_ab() == 0) {
            ((TileEntitySolarPanelFrame)this.getMaster()).getPanelReadySet().add(this);
        } else {
            ((TileEntitySolarPanelFrame)this.getMaster()).getPanelReadySet().remove(this);
        }
    }

    @Override
    public void checkForOutPuts() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EnumFacing facing = this.getBlockFacing();
        BlockPos currentPos = this.field_174879_c.func_177972_a(facing);
        IBlockState state = this.field_145850_b.func_180495_p(currentPos);
        TileEntity te = this.field_145850_b.func_175625_s(currentPos);
        if (te == null) {
            return;
        }
        if (!(state.func_177230_c() instanceof BlockSolarPanelFrame) && te.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
            this.addMachine(te, facing);
        } else {
            this.removeMachine(te);
        }
    }

    public void getEnergyFromSun() {
        if (this.field_145850_b.field_73011_w.func_191066_m() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177972_a(EnumFacing.UP)) && this.field_145850_b.func_175657_ab() == 0) {
            this.energyCanOutput = TileEntitySolarPanelBase.getGeneration(this.field_145850_b, this.field_174879_c) * this.panelReady.size() * this.getMultiplier();
        }
    }

    private int getMultiplier() {
        return IRConfig.MainConfig.Main.panelFrameMultiplier;
    }

    @Override
    public void onBlockBreak() {
        if (this.panelInv) {
            Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, new ItemStack((Block)ModBlocks.spanel));
        }
        super.onBlockBreak();
    }

    public boolean hasPanel() {
        return this.panelInv;
    }

    public ItemStack getPanel() {
        return this.panelStack;
    }

    public EnumFacing getBlockFacing() {
        if (this.blockFacing == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.blockFacing = state.func_177230_c() instanceof BlockSolarPanelFrame ? (EnumFacing)state.func_177229_b((IProperty)BlockSolarPanelFrame.FACING) : EnumFacing.NORTH;
        }
        return this.blockFacing;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.panelInv = compound.func_74767_n("panel");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("panel", this.panelInv);
        return super.func_189515_b(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == this.getBlockFacing()) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }
}

