/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.tileentity.TileEntityHVConnectorBase;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import cassiokf.industrialrenewal.util.MachinesUtils;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import cassiokf.industrialrenewal.util.interfaces.IConnectorHV;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTransformerHV
extends TileEntityMultiBlockBase<TileEntityTransformerHV>
implements IConnectorHV {
    private final VoltsEnergyContainer energyContainer;
    private final VoltsEnergyContainer dummyEnergyContainer;
    IConnectorHV otherSideTransformer;
    public boolean isOutPut;
    private BlockPos cableConnectionPos;
    private int energyTransfer;
    private boolean oldOutPut;
    private boolean isConnected;
    public int averageEnergy;
    private int oldEnergy;
    private int tick;
    private boolean inUse = false;

    public TileEntityTransformerHV() {
        this.energyContainer = new VoltsEnergyContainer(IRConfig.MainConfig.Main.maxHVTransformerTransferAmount, IRConfig.MainConfig.Main.maxHVTransformerTransferAmount, IRConfig.MainConfig.Main.maxHVTransformerTransferAmount){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                return TileEntityTransformerHV.this.onEnergyReceived(maxReceive, simulate);
            }
        };
        this.dummyEnergyContainer = new VoltsEnergyContainer(0, 0, 0){

            @Override
            public boolean canExtract() {
                return false;
            }

            @Override
            public boolean canReceive() {
                return false;
            }
        };
    }

    public int onEnergyReceived(int maxReceive, boolean simulate) {
        if (maxReceive <= 0) {
            return 0;
        }
        if (this.inUse) {
            return 0;
        }
        this.inUse = true;
        int out = 0;
        if (!this.isOutPut) {
            if (this.otherSideTransformer != null) {
                out = this.otherSideTransformer.receiveEnergy(Math.min(maxReceive, this.energyContainer.getMaxOutput()), simulate);
            }
        } else {
            IEnergyStorage outPutStorage;
            BlockPos outPutPos = this.field_174879_c.func_177967_a(this.getMasterFacing().func_176734_d(), 2).func_177977_b();
            TileEntity outTileEntity = this.field_145850_b.func_175625_s(outPutPos);
            if (outTileEntity != null && (outPutStorage = (IEnergyStorage)outTileEntity.getCapability(CapabilityEnergy.ENERGY, this.getMasterFacing())) != null && outPutStorage.canReceive()) {
                out = outPutStorage.receiveEnergy(maxReceive, simulate);
            }
        }
        if (!simulate) {
            this.energyTransfer += out;
        }
        this.inUse = false;
        return out;
    }

    @Override
    public void onTick() {
        if (!this.field_145850_b.field_72995_K && this.isMaster()) {
            if (this.tick >= 10) {
                this.tick = 0;
                this.isOutPut();
                this.averageEnergy = this.energyTransfer / 10;
                this.energyTransfer = 0;
                if (this.averageEnergy != this.oldEnergy) {
                    this.oldEnergy = this.averageEnergy;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    private void isOutPut() {
        EnumFacing facing = this.getMasterFacing();
        BlockPos posPort = this.field_174879_c.func_177972_a(facing.func_176746_e()).func_177972_a(facing.func_176734_d()).func_177977_b();
        boolean bl = this.isOutPut = this.field_145850_b.func_175640_z(posPort) || this.field_145850_b.func_175640_z(posPort.func_177972_a(facing.func_176734_d()));
        if (this.isOutPut != this.oldOutPut) {
            this.oldOutPut = this.isOutPut;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
            this.sync();
            this.checkIfNeedsNetworkRefresh();
        }
    }

    private void checkIfNeedsNetworkRefresh() {
        if (this.isMaster() && this.isConnected()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.cableConnectionPos);
            if (te instanceof IConnectorHV) {
                if (this.isOutPut && !((IConnectorHV)te).isOutput() || !this.isOutPut && ((IConnectorHV)te).isOutput()) {
                    this.setOtherSideTransformer((IConnectorHV)te);
                    ((IConnectorHV)te).setOtherSideTransformer(this);
                } else {
                    this.setOtherSideTransformer(null);
                    ((IConnectorHV)te).setOtherSideTransformer(null);
                }
            } else if (te instanceof TileEntityHVConnectorBase) {
                ((TileEntityHVConnectorBase)te).forceRecheck();
            }
        }
    }

    @Override
    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return MachinesUtils.getBlocksIn3x2x3CenteredPlus1OnTop(centerPosition);
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TileEntityTransformerHV;
    }

    public String getGenerationText() {
        int energy = this.averageEnergy;
        return Utils.formatEnergyString(energy) + "/t";
    }

    public float getGenerationFill() {
        float currentAmount = this.averageEnergy;
        float totalCapacity = this.energyContainer.getMaxOutput();
        return (currentAmount /= totalCapacity) * 90.0f;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.cableConnectionPos != null) {
            compound.func_74772_a("conP", this.cableConnectionPos.func_177986_g());
        } else {
            compound.func_74772_a("conP", 0L);
        }
        compound.func_74757_a("connected", this.isConnected);
        compound.func_74757_a("isOutPut", this.isOutPut);
        compound.func_74768_a("energy_average", this.averageEnergy);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        long conL = compound.func_74763_f("conP");
        this.cableConnectionPos = conL == 0L ? null : BlockPos.func_177969_a((long)conL);
        this.isConnected = compound.func_74767_n("connected");
        this.isOutPut = compound.func_74767_n("isOutPut");
        this.averageEnergy = compound.func_74762_e("energy_average");
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntityTransformerHV masterTE = (TileEntityTransformerHV)this.getMaster();
        if (masterTE == null) {
            return (T)super.getCapability(capability, facing);
        }
        EnumFacing face = masterTE.getMasterFacing();
        if (facing == face.func_176734_d() && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177977_b().func_177972_a(face.func_176734_d())) && capability == CapabilityEnergy.ENERGY) {
            return (T)(masterTE.isOutPut ? CapabilityEnergy.ENERGY.cast((Object)this.dummyEnergyContainer) : CapabilityEnergy.ENERGY.cast((Object)masterTE.energyContainer));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onMasterBreak() {
        if (this.isConnected()) {
            this.removeConnectionAndSpawn();
        }
    }

    private void disableConnectedCables(BlockPos connectedPos) {
        TileEntity te = this.field_145850_b.func_175625_s(connectedPos);
        if (te instanceof TileEntityHVConnectorBase) {
            ((TileEntityHVConnectorBase)te).removeConnection(this.getConnectorPos());
        } else if (te instanceof IConnectorHV) {
            ((IConnectorHV)te).removeConnection();
        }
    }

    public void removeConnectionAndSpawn() {
        BlockPos connectorPos = this.getConnectorPos();
        if (!this.field_145850_b.field_72995_K) {
            Utils.spawnItemStack(this.field_145850_b, connectorPos, new ItemStack((Item)ModItems.coilHV));
        }
        this.disableConnectedCables(this.cableConnectionPos);
        this.removeConnection();
    }

    @Override
    public boolean isOutput() {
        return ((TileEntityTransformerHV)this.getMaster()).isOutPut;
    }

    @Override
    public BlockPos getConnectionPos() {
        return ((TileEntityTransformerHV)this.getMaster()).cableConnectionPos;
    }

    @Override
    public void setConnectionPos(BlockPos endPos) {
        ((TileEntityTransformerHV)this.getMaster()).cableConnectionPos = endPos;
        ((TileEntityTransformerHV)this.getMaster()).isConnected = true;
        if (this.field_145850_b.func_175625_s(endPos) instanceof IConnectorHV) {
            ((TileEntityTransformerHV)this.getMaster()).checkIfNeedsNetworkRefresh();
        }
        ((TileEntityTransformerHV)this.getMaster()).sync();
    }

    @Override
    public BlockPos getConnectorPos() {
        return this.getMaster() != null ? ((TileEntityTransformerHV)this.getMaster()).func_174877_v().func_177984_a() : this.field_174879_c;
    }

    @Override
    public void setOtherSideTransformer(IConnectorHV transformer) {
        ((TileEntityTransformerHV)this.getMaster()).otherSideTransformer = transformer;
        ((TileEntityTransformerHV)this.getMaster()).sync();
    }

    @Override
    public boolean isConnected() {
        return ((TileEntityTransformerHV)this.getMaster()).isConnected;
    }

    @Override
    public int receiveEnergy(int quantity, boolean simulate) {
        if (this.func_145837_r()) {
            return 0;
        }
        return ((TileEntityTransformerHV)this.getMaster()).energyContainer.receiveEnergy(quantity, simulate);
    }

    @Override
    public void removeConnection() {
        if (this.isConnected()) {
            ((TileEntityTransformerHV)this.getMaster()).isConnected = false;
            ((TileEntityTransformerHV)this.getMaster()).cableConnectionPos = null;
            ((TileEntityTransformerHV)this.getMaster()).otherSideTransformer = null;
            ((TileEntityTransformerHV)this.getMaster()).sync();
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

