/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockWindTurbinePillar;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCable;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityWindTurbinePillar
extends TileEntityEnergyCable {
    private static final VoltsEnergyContainer dummyEnergyContainer = new VoltsEnergyContainer(0, 0, 0){

        @Override
        public boolean canReceive() {
            return false;
        }

        @Override
        public boolean canExtract() {
            return false;
        }
    };
    private float amount;
    private EnumFacing facing;
    private static final EnumFacing[] faces = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    private boolean isBase;

    @Override
    public int getMaxEnergyToTransport() {
        return IRConfig.MainConfig.Main.maxEnergySWindTurbine;
    }

    @Override
    public void beforeInitialize() {
        this.getIsBase();
        this.sync();
    }

    @Override
    public EnumFacing[] getFacesToCheck() {
        return faces;
    }

    @Override
    public boolean instanceOf(TileEntity te) {
        return te instanceof TileEntityWindTurbinePillar;
    }

    @Override
    public void checkForOutPuts() {
        this.getIsBase();
        this.outPut = 0;
        this.potentialEnergy = 0;
        if (!this.field_145850_b.field_72995_K && this.isBase) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                BlockPos currentPos = this.field_174879_c.func_177972_a(face);
                TileEntity te = this.field_145850_b.func_175625_s(currentPos);
                boolean hasMachine = !(te instanceof TileEntityWindTurbinePillar) && te != null;
                IEnergyStorage cap = null;
                if (hasMachine) {
                    cap = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
                }
                if (hasMachine && cap != null && cap.canReceive()) {
                    this.addMachine(te, face);
                    continue;
                }
                this.removeMachine(te);
            }
        }
        this.sync();
    }

    public EnumFacing getBlockFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.facing = state.func_177230_c() instanceof BlockWindTurbinePillar ? (EnumFacing)state.func_177229_b((IProperty)BlockWindTurbinePillar.FACING) : EnumFacing.NORTH;
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public float getGenerationForGauge() {
        float currentAmount = Utils.normalizeClamped(((TileEntityEnergyCable)this.getMaster()).averageEnergy, 0.0f, 128.0f);
        this.amount = Utils.lerp(this.amount, currentAmount, 0.1f);
        return Math.min(this.amount, 1.0f) * 90.0f;
    }

    public float getPotentialValue() {
        float currentAmount = Utils.normalizeClamped(((TileEntityEnergyCable)this.getMaster()).potentialEnergy, 0.0f, 128.0f);
        return currentAmount * 90.0f;
    }

    public String getText() {
        return ((TileEntityEnergyCable)this.getMaster()).averageEnergy + " FE/t";
    }

    public boolean isBase() {
        return this.isBase;
    }

    public boolean getIsBase() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        this.isBase = !(state.func_177230_c() instanceof BlockWindTurbinePillar);
        return this.isBase;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (facing == EnumFacing.UP) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)((TileEntityEnergyCable)this.getMaster()).energyContainer);
            }
            if (this.isBase) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)dummyEnergyContainer);
            }
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.isBase = compound.func_74767_n("base");
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            this.potentialEnergy = compound.func_74762_e("potential");
        }
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            this.outPut = compound.func_74762_e("outPut");
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("base", this.isBase);
        compound.func_74768_a("potential", this.potentialEnergy);
        compound.func_74768_a("outPut", this.outPut);
        return super.func_189515_b(compound);
    }
}

