/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.abstracts;

import cassiokf.industrialrenewal.blocks.abstracts.BlockMultiBlockBase;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.util.MachinesUtils;
import cassiokf.industrialrenewal.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMultiBlockBase<TE extends TileEntityMultiBlockBase>
extends TileEntitySync
implements ITickable {
    boolean firstTick = false;
    private boolean isMaster;
    private boolean breaking;
    private boolean startBreaking;
    private TE masterTE;
    private boolean masterChecked = false;
    private boolean faceChecked = false;
    private int faceIndex;

    public void func_73660_a() {
        if (!this.firstTick) {
            this.firstTick = true;
            this.isMaster();
            if (this.isMaster()) {
                this.setMaster();
            }
            this.onFirstTick();
        }
        this.onTick();
    }

    public void onTick() {
    }

    public void onFirstTick() {
    }

    public TE getMaster() {
        if (this.isMaster) {
            return (TE)this;
        }
        if (this.masterTE == null || this.masterTE.func_145837_r()) {
            List<BlockPos> list = MachinesUtils.getBlocksIn3x3x3Centered(this.field_174879_c);
            for (BlockPos currentPos : list) {
                TileEntity te = this.field_145850_b.func_175625_s(currentPos);
                if (!(te instanceof TileEntityMultiBlockBase) || !((TileEntityMultiBlockBase)te).isMaster() || !this.instanceOf(te)) continue;
                this.setMaster((TileEntityMultiBlockBase)te);
                ((TileEntityMultiBlockBase)te).setMaster();
                return this.masterTE;
            }
            if (!this.field_145850_b.field_72995_K && !this.startBreaking) {
                Utils.sendConsoleMessage("MultiBlock Machine: " + this.func_145838_q().toString() + " has no Master at " + this.field_174879_c);
                Utils.sendConsoleMessage(" Break this machine and try replace it, If this does not work, report the problem:");
                Utils.sendConsoleMessage("https://github.com/Cassiobsk8/Industrial_Renewal/issues/new?template=bug_report.md");
            }
            return (TE)this;
        }
        return this.masterTE;
    }

    public void setMaster() {
        if (!this.isMaster()) {
            return;
        }
        List<BlockPos> list = this.getListOfBlockPositions(this.field_174879_c);
        for (BlockPos currentPos : list) {
            TileEntity te = this.field_145850_b.func_175625_s(currentPos);
            if (!(te instanceof TileEntityMultiBlockBase) || !this.instanceOf(te)) continue;
            ((TileEntityMultiBlockBase)te).setMaster(this);
        }
    }

    @Override
    public void sync() {
        if (this.isMaster) {
            super.sync();
        }
    }

    public void breakMultiBlocks() {
        this.startBreaking = true;
        if (!this.isMaster()) {
            if (this.getMaster() != this) {
                ((TileEntityMultiBlockBase)this.getMaster()).breakMultiBlocks();
            }
            return;
        }
        if (!this.breaking) {
            this.breaking = true;
            this.onMasterBreak();
            List<BlockPos> list = this.getListOfBlockPositions(this.field_174879_c);
            for (BlockPos currentPos : list) {
                Block block = this.field_145850_b.func_180495_p(currentPos).func_177230_c();
                if (!(block instanceof BlockMultiBlockBase)) continue;
                this.field_145850_b.func_175698_g(currentPos);
            }
        }
    }

    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return MachinesUtils.getBlocksIn3x3x3Centered(centerPosition);
    }

    public abstract boolean instanceOf(TileEntity var1);

    public EnumFacing getMasterFacing() {
        if (this.faceChecked) {
            return EnumFacing.func_82600_a((int)this.faceIndex);
        }
        EnumFacing facing = this.getBlockFace();
        this.faceChecked = true;
        this.faceIndex = facing.func_176745_a();
        return facing;
    }

    public EnumFacing getBlockFace() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockMultiBlockBase) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMultiBlockBase.FACING);
        }
        return EnumFacing.NORTH;
    }

    public void onMasterBreak() {
    }

    public boolean isMaster() {
        if (this.masterChecked) {
            return this.isMaster;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockMultiBlockBase)) {
            return false;
        }
        this.isMaster = (Boolean)state.func_177229_b((IProperty)BlockMultiBlockBase.MASTER);
        this.masterChecked = true;
        return this.isMaster;
    }

    public void setMaster(TE master) {
        this.masterTE = master;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("master", this.isMaster());
        compound.func_74757_a("checked", this.masterChecked);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.isMaster = compound.func_74767_n("master");
        this.masterChecked = compound.func_74767_n("checked");
        super.func_145839_a(compound);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177963_a(-1.0, -1.0, -1.0), this.field_174879_c.func_177963_a(2.0, 2.0, 2.0));
    }
}

