/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.tubes;

import cassiokf.industrialrenewal.blocks.pipes.BlockEnergyCable;
import cassiokf.industrialrenewal.blocks.pipes.BlockFluidPipe;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.enums.EnumCableIn;
import java.util.ArrayList;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;

public class TileEntityCableTray
extends TileEntityMultiBlocksTube<TileEntityCableTray> {
    private EnumCableIn energyCable = EnumCableIn.NONE;
    private boolean fluidPipe = false;
    private boolean dataCable = false;

    @Override
    public void func_73660_a() {
    }

    public boolean onBlockActivated(EntityPlayer player, ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block instanceof BlockFluidPipe && !this.fluidPipe) {
            this.fluidPipe = true;
            if (!this.field_145850_b.field_72995_K && !player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.refreshConnections();
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.sync();
            }
            return true;
        }
        if (block instanceof BlockEnergyCable && this.energyCable.equals((Object)EnumCableIn.NONE)) {
            switch (((BlockEnergyCable)block).type) {
                default: {
                    this.energyCable = EnumCableIn.LV;
                    break;
                }
                case MV: {
                    this.energyCable = EnumCableIn.MV;
                    break;
                }
                case HV: {
                    this.energyCable = EnumCableIn.HV;
                }
            }
            if (!this.field_145850_b.field_72995_K && !player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.refreshConnections();
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.sync();
            }
            return true;
        }
        if (stack.func_77973_b() instanceof ItemPowerScrewDrive && (this.fluidPipe || this.dataCable || this.energyCable != EnumCableIn.NONE)) {
            if (!player.func_184812_l_()) {
                this.spawnBlocks(player);
            }
            this.fluidPipe = false;
            this.dataCable = false;
            this.energyCable = EnumCableIn.NONE;
            this.refreshConnections();
            if (!this.field_145850_b.field_72995_K) {
                ItemPowerScrewDrive.playDrillSound(this.field_145850_b, this.field_174879_c);
                this.sync();
            }
            return true;
        }
        return false;
    }

    private void spawnBlocks(EntityPlayer player) {
        ItemStack stack;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.fluidPipe) {
            stack = new ItemStack(Item.func_150898_a((Block)ModBlocks.fluidPipe), 1);
            if (player != null) {
                player.field_71071_by.func_70441_a(stack);
            } else {
                Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, stack);
            }
        }
        if (this.energyCable != EnumCableIn.NONE) {
            switch (this.energyCable) {
                case LV: {
                    stack = new ItemStack(Item.func_150898_a((Block)ModBlocks.energyCableLV), 1);
                    if (player != null) {
                        player.field_71071_by.func_70441_a(stack);
                        break;
                    }
                    Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, stack);
                    break;
                }
                case MV: {
                    ItemStack stack2 = new ItemStack(Item.func_150898_a((Block)ModBlocks.energyCableMV), 1);
                    if (player != null) {
                        player.field_71071_by.func_70441_a(stack2);
                        break;
                    }
                    Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, stack2);
                    break;
                }
                case HV: {
                    ItemStack stack3 = new ItemStack(Item.func_150898_a((Block)ModBlocks.energyCableHV), 1);
                    if (player != null) {
                        player.field_71071_by.func_70441_a(stack3);
                        break;
                    }
                    Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, stack3);
                }
            }
        }
    }

    public boolean hasPipe() {
        return this.fluidPipe;
    }

    public boolean hasData() {
        return this.dataCable;
    }

    public EnumCableIn getCableIn() {
        return this.energyCable;
    }

    @Override
    public boolean isMaster() {
        return false;
    }

    @Override
    public void setMaster(TileEntityCableTray master) {
    }

    @Override
    public void checkForOutPuts() {
    }

    @Override
    public boolean instanceOf(TileEntity te) {
        return te instanceof TileEntityCableTray;
    }

    @Override
    public boolean isTray() {
        return true;
    }

    public void refreshConnections() {
        if (IRConfig.MainConfig.Main.debugMessages) {
            System.out.println("Refresh connections at" + this.field_174879_c);
        }
        ArrayList<TileEntityMultiBlocksTube> connectedCables = new ArrayList<TileEntityMultiBlocksTube>();
        ArrayList<TileEntityCableTray> cableTrayList = new ArrayList<TileEntityCableTray>();
        Stack<TileEntityCableTray> traversingCables = new Stack<TileEntityCableTray>();
        traversingCables.add(this);
        while (!traversingCables.isEmpty()) {
            TileEntityCableTray storage = (TileEntityCableTray)traversingCables.pop();
            cableTrayList.add(storage);
            for (EnumFacing d : this.getFacesToCheck()) {
                TileEntity te = this.field_145850_b.func_175625_s(storage.func_174877_v().func_177972_a(d));
                if (this.instanceOf(te) && !cableTrayList.contains(te)) {
                    traversingCables.add((TileEntityCableTray)te);
                    continue;
                }
                if (this.instanceOf(te) || !(te instanceof TileEntityMultiBlocksTube) || connectedCables.contains(te)) continue;
                connectedCables.add((TileEntityMultiBlocksTube)te);
            }
        }
        for (TileEntityMultiBlocksTube cables : connectedCables) {
            cables.initializeMultiblockIfNecessary(true);
        }
    }

    @Override
    public void onBlockBreak() {
        this.spawnBlocks(null);
        super.onBlockBreak();
        this.refreshConnections();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.fluidPipe = compound.func_74767_n("fluidPipe");
        this.dataCable = compound.func_74767_n("dataCable");
        this.energyCable = EnumCableIn.byIndex(compound.func_74762_e("energyCableIn"));
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("fluidPipe", this.fluidPipe);
        compound.func_74757_a("dataCable", this.dataCable);
        compound.func_74768_a("energyCableIn", this.energyCable.getIndex());
        return super.func_189515_b(compound);
    }
}

