/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import mezz.itemzoom.client.KeyBindings;
import mezz.itemzoom.client.config.Config;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InputHandler {
    private final Config config;
    private final KeyBindings keyBindings;
    private boolean enableKeyHeld = false;

    public InputHandler(Config config, KeyBindings keyBindings) {
        this.config = config;
        this.keyBindings = keyBindings;
    }

    public boolean handleInput(InputMappings.Input input) {
        if (this.keyBindings.toggle.isActiveAndMatches(input)) {
            this.config.toggleEnabled();
            return true;
        }
        if (this.keyBindings.zoomIn.isActiveAndMatches(input)) {
            this.config.increaseZoom();
            return true;
        }
        if (this.keyBindings.zoomOut.isActiveAndMatches(input)) {
            this.config.decreaseZoom();
            return true;
        }
        if (this.keyBindings.hold.isActiveAndMatches(input)) {
            this.enableKeyHeld = true;
            return true;
        }
        return false;
    }

    public boolean handleInputReleased(InputMappings.Input input) {
        if (this.keyBindings.hold.isActiveAndMatches(input)) {
            this.enableKeyHeld = false;
            return true;
        }
        return false;
    }

    public boolean isEnableKeyHeld() {
        return this.enableKeyHeld;
    }
}

