/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.Internal;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IPaged;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.Tuple;

public class PageNavigation {
    private final IPaged paged;
    private final GuiIconButton nextButton;
    private final GuiIconButton backButton;
    private final boolean hideOnSinglePage;
    private String pageNumDisplayString = "1/1";
    private int pageNumDisplayX;
    private int pageNumDisplayY;
    private Rectangle2d area = new Rectangle2d(0, 0, 0, 0);

    public PageNavigation(IPaged paged, boolean hideOnSinglePage) {
        this.paged = paged;
        Textures textures = Internal.getTextures();
        this.nextButton = new GuiIconButton(textures.getArrowNext(), b -> paged.nextPage());
        this.backButton = new GuiIconButton(textures.getArrowPrevious(), b -> paged.previousPage());
        this.hideOnSinglePage = hideOnSinglePage;
    }

    public void updateBounds(Rectangle2d area) {
        this.area = area;
        int buttonSize = area.func_199317_d();
        Tuple<Rectangle2d, Rectangle2d> result = MathUtil.splitX(area, buttonSize);
        this.backButton.updateBounds((Rectangle2d)result.func_76341_a());
        result = MathUtil.splitXRight(area, buttonSize);
        this.nextButton.updateBounds((Rectangle2d)result.func_76340_b());
    }

    public void updatePageState() {
        int pageNum = this.paged.getPageNumber();
        int pageCount = this.paged.getPageCount();
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        this.pageNumDisplayString = pageNum + 1 + "/" + pageCount;
        Rectangle2d centerArea = MathUtil.centerTextArea(this.area, fontRenderer, this.pageNumDisplayString);
        this.pageNumDisplayX = centerArea.func_199318_a();
        this.pageNumDisplayY = centerArea.func_199319_b();
    }

    public void draw(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious()) {
            minecraft.field_71466_p.func_238405_a_(matrixStack, this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, -1);
            this.nextButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.backButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.nextButton.func_231047_b_(mouseX, mouseY) || this.backButton.func_231047_b_(mouseX, mouseY);
    }

    public boolean handleMouseClickedButtons(double mouseX, double mouseY, int mouseButton) {
        return this.nextButton.func_231044_a_(mouseX, mouseY, mouseButton) || this.backButton.func_231044_a_(mouseX, mouseY, mouseButton);
    }
}

