/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableBlank;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;

public abstract class GuiIconToggleButton {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final GuiIconButton button;
    private final HoverChecker hoverChecker;
    private final IMouseHandler mouseHandler;

    public GuiIconToggleButton(IDrawable offIcon, IDrawable onIcon) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.button = new GuiIconButton(new DrawableBlank(0, 0), b -> {});
        this.hoverChecker = new HoverChecker();
        this.hoverChecker.updateBounds(this.button);
        this.mouseHandler = new MouseHandler();
    }

    public void updateBounds(Rect2i area) {
        this.button.m_93674_(area.m_110090_());
        this.button.setHeight(area.m_110091_());
        this.button.f_93620_ = area.m_110085_();
        this.button.f_93621_ = area.m_110086_();
        this.hoverChecker.updateBounds(this.button);
    }

    public void draw(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        IDrawable icon = this.isIconToggledOn() ? this.onIcon : this.offIcon;
        icon.draw(poseStack, this.button.f_93620_ + 2, this.button.f_93621_ + 2);
    }

    public final boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public final void drawTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            this.getTooltips(tooltip);
            TooltipRenderer.drawHoveringText(tooltip, mouseX, mouseY, 150, poseStack);
        }
    }

    protected abstract void getTooltips(List<Component> var1);

    protected abstract boolean isIconToggledOn();

    protected abstract boolean onMouseClicked(MouseClickState var1);

    private class MouseHandler
    implements IMouseHandler {
        private MouseHandler() {
        }

        @Override
        @Nullable
        public final IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            IMouseHandler mouseHandler;
            IMouseHandler handled;
            if (GuiIconToggleButton.this.isMouseOver(mouseX, mouseY) && (handled = (mouseHandler = GuiIconToggleButton.this.button.getMouseHandler()).handleClick(screen, mouseX, mouseY, mouseButton, clickState)) != null && GuiIconToggleButton.this.onMouseClicked(clickState)) {
                return this;
            }
            return null;
        }
    }
}

