/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.JEIClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class ConfigButton
extends GuiIconToggleButton {
    private final IngredientListOverlay parent;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(IngredientListOverlay parent, IWorldConfig worldConfig) {
        Textures textures = Internal.getTextures();
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), parent, worldConfig);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, IngredientListOverlay parent, IWorldConfig worldConfig) {
        super(disabledIcon, enabledIcon);
        this.parent = parent;
        this.worldConfig = worldConfig;
    }

    @Override
    protected void getTooltips(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            TranslatableComponent disabled = new TranslatableComponent("jei.tooltip.ingredient.list.disabled");
            TranslatableComponent overLay = new TranslatableComponent(KeyBindings.toggleOverlay.m_90865_());
            TranslatableComponent disabledFix = new TranslatableComponent("jei.tooltip.ingredient.list.disabled.how.to.fix", new Object[]{overLay});
            tooltip.add((Component)disabled.m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)disabledFix.m_130940_(ChatFormatting.GOLD));
        } else if (!this.parent.isListDisplayed()) {
            TranslatableComponent notEnoughSpace = new TranslatableComponent("jei.tooltip.not.enough.space");
            tooltip.add((Component)notEnoughSpace.m_130940_(ChatFormatting.GOLD));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            TranslatableComponent enabled = new TranslatableComponent("jei.tooltip.cheat.mode.button.enabled");
            tooltip.add((Component)enabled.m_130940_(ChatFormatting.RED));
            KeyMapping toggleCheatMode = KeyBindings.toggleCheatMode;
            if (toggleCheatMode.getKey().m_84873_() != 0) {
                TranslatableComponent cheatMode = new TranslatableComponent(toggleCheatMode.m_90865_());
                TranslatableComponent disableHotkey = new TranslatableComponent("jei.tooltip.cheat.mode.how.to.disable.hotkey", new Object[]{cheatMode});
                tooltip.add((Component)disableHotkey.m_130940_(ChatFormatting.RED));
            } else {
                TranslatableComponent controlKeyLocalization = new TranslatableComponent(Minecraft.f_91002_ ? "key.jei.ctrl.mac" : "key.jei.ctrl");
                TranslatableComponent noHotKey = new TranslatableComponent("jei.tooltip.cheat.mode.how.to.disable.no.hotkey", new Object[]{controlKeyLocalization});
                tooltip.add((Component)noHotKey.m_130940_(ChatFormatting.RED));
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(MouseClickState clickState) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!clickState.isSimulate()) {
                if (Screen.m_96637_()) {
                    this.worldConfig.toggleCheatItemsEnabled();
                } else {
                    JEIClientConfig.openSettings();
                }
            }
            return true;
        }
        return false;
    }
}

