/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.config.IFilterTextSource;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.ghost.IGhostIngredientDragSource;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.CombinedMouseHandler;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Size2i;

public class IngredientGridWithNavigation
implements IShowsRecipeFocuses,
IGhostIngredientDragSource {
    private static final int NAVIGATION_HEIGHT = 20;
    private int firstItemIndex = 0;
    private final IngredientGridPaged pageDelegate;
    private final PageNavigation navigation;
    private final GuiScreenHelper guiScreenHelper;
    private final IFilterTextSource filterTextSource;
    private final IWorldConfig worldConfig;
    private final IngredientGrid ingredientGrid;
    private final IIngredientGridSource ingredientSource;
    private final IMouseHandler mouseHandler;
    private Rect2i area = new Rect2i(0, 0, 0, 0);

    public IngredientGridWithNavigation(IIngredientGridSource ingredientSource, IFilterTextSource filterTextSource, GuiScreenHelper guiScreenHelper, IngredientGrid ingredientGrid, IWorldConfig worldConfig) {
        this.filterTextSource = filterTextSource;
        this.worldConfig = worldConfig;
        this.ingredientGrid = ingredientGrid;
        this.ingredientSource = ingredientSource;
        this.guiScreenHelper = guiScreenHelper;
        this.pageDelegate = new IngredientGridPaged();
        this.navigation = new PageNavigation(this.pageDelegate, false);
        this.mouseHandler = new CombinedMouseHandler(this.pageDelegate, this.ingredientGrid.getMouseHandler(), this.navigation.getMouseHandler());
    }

    public void updateLayout(boolean resetToFirstPage) {
        String filterText;
        List<IIngredientListElement<?>> ingredientList;
        if (resetToFirstPage) {
            this.firstItemIndex = 0;
        }
        if (this.firstItemIndex >= (ingredientList = this.ingredientSource.getIngredientList(filterText = this.filterTextSource.getFilterText())).size()) {
            this.firstItemIndex = 0;
        }
        this.ingredientGrid.guiIngredientSlots.set(this.firstItemIndex, ingredientList);
        this.navigation.updatePageState();
    }

    public boolean updateBounds(Rect2i availableArea, Set<Rect2i> guiExclusionAreas) {
        Tuple<Rect2i, Rect2i> result = MathUtil.splitY(availableArea, 20);
        Rect2i estimatedNavigationArea = (Rect2i)result.m_14418_();
        List<Rect2i> intersectsNavigationArea = guiExclusionAreas.stream().filter(rectangle2d -> MathUtil.intersects(rectangle2d, estimatedNavigationArea)).toList();
        int maxWidth = this.ingredientGrid.maxWidth();
        int maxHeight = availableArea.m_110091_();
        if (maxWidth <= 0 || maxHeight <= 0) {
            return false;
        }
        Size2i maxContentSize = new Size2i(maxWidth, maxHeight);
        if (MathUtil.contentArea(availableArea = MathUtil.cropToAvoidIntersection(intersectsNavigationArea, availableArea, maxContentSize), maxContentSize) == 0) {
            return false;
        }
        result = MathUtil.splitY(availableArea, 20);
        Rect2i navigationArea = (Rect2i)result.m_14418_();
        Rect2i boundsWithoutNavigation = (Rect2i)result.m_14419_();
        boolean gridHasRoom = this.ingredientGrid.updateBounds(boundsWithoutNavigation, guiExclusionAreas);
        if (!gridHasRoom) {
            return false;
        }
        Rect2i displayArea = this.ingredientGrid.getArea();
        navigationArea = new Rectangle2dBuilder(navigationArea).setX(displayArea).setWidth(displayArea).build();
        this.navigation.updateBounds(navigationArea);
        this.area = MathUtil.union(displayArea, navigationArea);
        return true;
    }

    public Rect2i getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.ingredientGrid.draw(minecraft, poseStack, mouseX, mouseY);
        this.navigation.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        this.ingredientGrid.drawTooltips(minecraft, poseStack, mouseX, mouseY);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (KeyBindings.nextPage.isActiveAndMatches(input)) {
            this.pageDelegate.nextPage();
            return true;
        }
        if (KeyBindings.previousPage.isActiveAndMatches(input)) {
            this.pageDelegate.previousPage();
            return true;
        }
        return this.checkHotbarKeys(input);
    }

    protected boolean checkHotbarKeys(InputConstants.Key input) {
        double mouseY;
        double mouseX;
        Screen guiScreen = Minecraft.m_91087_().f_91080_;
        if (this.worldConfig.isCheatItemsEnabled() && guiScreen != null && !(guiScreen instanceof RecipesGui) && this.isMouseOver(mouseX = MouseUtil.getX(), mouseY = MouseUtil.getY())) {
            Options gameSettings = Minecraft.m_91087_().f_91066_;
            for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
                ItemStack itemStack;
                if (!gameSettings.f_92056_[hotbarSlot].isActiveAndMatches(input)) continue;
                IClickedIngredient<?> ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY);
                if (ingredientUnderMouse != null && !(itemStack = ingredientUnderMouse.getCheatItemStack()).m_41619_()) {
                    CommandUtil.setHotbarStack(itemStack, hotbarSlot);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY);
    }

    public <T> Optional<IIngredientListElement<T>> getElementUnderMouse(IIngredientType<T> ingredientType) {
        return this.ingredientGrid.getElementUnderMouse(ingredientType);
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.ingredientGrid.canSetFocusWithMouse();
    }

    public <T> List<IIngredientListElement<T>> getVisibleElements(IIngredientType<T> ingredientType) {
        return this.ingredientGrid.guiIngredientSlots.getAllGuiIngredientSlots().stream().map(slot -> slot.getIngredientRenderer(ingredientType)).filter(Objects::nonNull).map(IngredientListElementRenderer::getElement).toList();
    }

    private class IngredientGridPaged
    implements IPaged,
    IMouseHandler {
        private IngredientGridPaged() {
        }

        @Override
        public boolean nextPage() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            if (itemsCount > 0) {
                IngredientGridWithNavigation.this.firstItemIndex += IngredientGridWithNavigation.this.ingredientGrid.size();
                if (IngredientGridWithNavigation.this.firstItemIndex >= itemsCount) {
                    IngredientGridWithNavigation.this.firstItemIndex = 0;
                }
                IngredientGridWithNavigation.this.updateLayout(false);
                return true;
            }
            IngredientGridWithNavigation.this.firstItemIndex = 0;
            IngredientGridWithNavigation.this.updateLayout(false);
            return false;
        }

        @Override
        public boolean previousPage() {
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (itemsPerPage == 0) {
                IngredientGridWithNavigation.this.firstItemIndex = 0;
                IngredientGridWithNavigation.this.updateLayout(false);
                return false;
            }
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            int pageNum = IngredientGridWithNavigation.this.firstItemIndex / itemsPerPage;
            pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
            IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * pageNum;
            if (IngredientGridWithNavigation.this.firstItemIndex > 0 && IngredientGridWithNavigation.this.firstItemIndex == itemsCount) {
                IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * --pageNum;
            }
            IngredientGridWithNavigation.this.updateLayout(false);
            return true;
        }

        @Override
        public boolean hasNext() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size() > itemsPerPage;
        }

        @Override
        public boolean hasPrevious() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size() > itemsPerPage;
        }

        @Override
        public int getPageCount() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
            pageCount = Math.max(1, pageCount);
            return pageCount;
        }

        @Override
        public int getPageNumber() {
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 0;
            }
            return IngredientGridWithNavigation.this.firstItemIndex / stacksPerPage;
        }

        @Override
        public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            if (!IngredientGridWithNavigation.this.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            if (scrollDelta < 0.0) {
                this.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.previousPage();
                return true;
            }
            return false;
        }
    }
}

