/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ghost.GhostIngredientDragManager;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.click.MouseClickState;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;

public class IngredientListOverlay
implements IIngredientListOverlay,
IShowsRecipeFocuses {
    private static final int BORDER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final GuiTextFieldFilter searchField;
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private final IMouseHandler mouseHandler = new MouseHandler();
    private Rect2i displayArea = new Rect2i(0, 0, 0, 0);
    private boolean hasRoom;
    @Nullable
    private IGuiProperties guiProperties;

    public IngredientListOverlay(IIngredientGridSource ingredientGridSource, IngredientManager ingredientManager, GuiScreenHelper guiScreenHelper, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig) {
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        ingredientGridSource.addListener(() -> this.onSetFilterText(worldConfig.getFilterText()));
        this.searchField = new GuiTextFieldFilter(ingredientGridSource, worldConfig);
        this.configButton = ConfigButton.create(this, worldConfig);
        this.ghostIngredientDragManager = new GhostIngredientDragManager(this.contents, guiScreenHelper, ingredientManager, worldConfig);
        this.clearKeyboardFocus();
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isOverlayEnabled() && this.guiProperties != null && this.hasRoom;
    }

    private static Rect2i createDisplayArea(IGuiProperties guiProperties) {
        Rect2i screenRectangle = GuiProperties.getScreenRectangle(guiProperties);
        int guiRight = GuiProperties.getGuiRight(guiProperties);
        Tuple<Rect2i, Rect2i> result = MathUtil.splitX(screenRectangle, guiRight);
        Rect2i displayArea = (Rect2i)result.m_14419_();
        return new Rectangle2dBuilder(displayArea).insetByPadding(2).build();
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean forceUpdate) {
        boolean wasDisplayed = this.isListDisplayed();
        IGuiProperties guiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.clearKeyboardFocus();
                this.ghostIngredientDragManager.stopDrag();
            }
        } else if (forceUpdate || this.guiProperties == null || !GuiProperties.areEqual(this.guiProperties, guiProperties)) {
            this.updateNewScreen(guiProperties);
        }
        if (wasDisplayed && !this.isListDisplayed()) {
            this.worldConfig.saveFilterText();
        }
    }

    private void updateNewScreen(IGuiProperties guiProperties) {
        this.guiProperties = guiProperties;
        this.displayArea = IngredientListOverlay.createDisplayArea(guiProperties);
        boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(this.clientConfig, guiProperties);
        Set<Rect2i> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
        Rect2i availableContentsArea = new Rectangle2dBuilder(this.displayArea).subtractHeight(searchBarCentered ? 0 : 22).build();
        this.hasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        Rect2i contentsArea = this.contents.getArea();
        this.displayArea = new Rectangle2dBuilder(this.displayArea).setX(contentsArea).setWidth(contentsArea).build();
        Tuple<Rect2i, Rect2i> result = IngredientListOverlay.getSearchAndConfigArea(searchBarCentered, guiProperties, this.displayArea);
        Rect2i searchAndConfigArea = (Rect2i)result.m_14419_();
        result = MathUtil.splitXRight(searchAndConfigArea, 20);
        Rect2i searchArea = (Rect2i)result.m_14418_();
        Rect2i configButtonArea = (Rect2i)result.m_14419_();
        this.searchField.updateBounds(searchArea);
        this.configButton.updateBounds(configButtonArea);
        this.updateLayout(false);
    }

    private static boolean isSearchBarCentered(IClientConfig clientConfig, IGuiProperties guiProperties) {
        return clientConfig.isCenterSearchBarEnabled() && GuiProperties.getGuiBottom(guiProperties) + 20 < guiProperties.getScreenHeight();
    }

    private static Tuple<Rect2i, Rect2i> getSearchAndConfigArea(boolean searchBarCentered, IGuiProperties guiProperties, Rect2i displayArea) {
        if (searchBarCentered) {
            Rect2i guiRectangle = GuiProperties.getGuiRectangle(guiProperties);
            Rect2i searchRect = new Rect2i(guiRectangle.m_110085_(), displayArea.m_110091_() - 20, guiRectangle.m_110090_(), 20);
            return new Tuple((Object)displayArea, (Object)searchRect);
        }
        return MathUtil.splitYBottom(displayArea, 20);
    }

    public void updateLayout(boolean filterChanged) {
        this.contents.updateLayout(filterChanged);
        this.searchField.update();
    }

    public void drawScreen(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.searchField.m_6303_(poseStack, mouseX, mouseY, partialTicks);
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.guiProperties != null) {
            this.configButton.draw(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.ghostIngredientDragManager.drawTooltips(minecraft, poseStack, mouseX, mouseY);
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            this.configButton.drawTooltips(poseStack, mouseX, mouseY);
        }
    }

    public void drawOnForeground(Minecraft minecraft, PoseStack poseStack, AbstractContainerScreen<?> gui, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-gui.getGuiLeft()), (double)(-gui.getGuiTop()), 0.0);
            this.ghostIngredientDragManager.drawOnForeground(minecraft, poseStack, mouseX, mouseY);
            poseStack.m_85849_();
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.searchField.m_94120_();
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            if (this.clientConfig.isCenterSearchBarEnabled() && this.searchField.m_5953_(mouseX, mouseY)) {
                return true;
            }
            return MathUtil.contains(this.displayArea, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            return this.configButton.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    private ClickResult handleMouseClickedInternal(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        IMouseHandler mouseHandler;
        IMouseHandler mouseHandled;
        if (this.isListDisplayed() && this.ghostIngredientDragManager.handleMouseClicked(screen, mouseX, mouseY, mouseButton, clickState)) {
            return new ClickResult(true, false);
        }
        if (this.guiProperties != null && (mouseHandled = (mouseHandler = this.configButton.getMouseHandler()).handleClick(screen, mouseX, mouseY, mouseButton, clickState)) != null) {
            return new ClickResult(true, false);
        }
        if (this.isListDisplayed()) {
            if (this.contents.getMouseHandler().handleClick(screen, mouseX, mouseY, mouseButton, clickState) != null) {
                return new ClickResult(true, false);
            }
            if (this.handleSearchClick(screen, mouseX, mouseY, mouseButton, clickState)) {
                return new ClickResult(true, true);
            }
            if (IngredientListOverlay.handleCheatClick(this, mouseX, mouseY, mouseButton, this.worldConfig, this.clientConfig, clickState)) {
                return new ClickResult(true, false);
            }
        }
        return new ClickResult(false, false);
    }

    private boolean handleSearchClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        IMouseHandler mouseHandler = this.searchField.getMouseHandler();
        IMouseHandler handled = mouseHandler.handleClick(screen, mouseX, mouseY, mouseButton, clickState);
        if (handled != null) {
            if (!clickState.isSimulate()) {
                this.updateLayout(true);
            }
            return true;
        }
        return false;
    }

    private static boolean handleCheatClick(IShowsRecipeFocuses showsRecipeFocuses, double mouseX, double mouseY, int mouseButton, IWorldConfig worldConfig, IClientConfig clientConfig, MouseClickState clickState) {
        ItemStack itemStack;
        if (!worldConfig.isCheatItemsEnabled()) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Screen currentScreen = minecraft.f_91080_;
        if (currentScreen == null || currentScreen instanceof RecipesGui) {
            return false;
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(mouseButton);
        if (mouseButton != 0 && mouseButton != 1 && !minecraft.f_91066_.f_92097_.isActiveAndMatches(input)) {
            return false;
        }
        IClickedIngredient<?> clicked = showsRecipeFocuses.getIngredientUnderMouse(mouseX, mouseY);
        if (clicked == null) {
            return false;
        }
        if (!clickState.isSimulate() && !(itemStack = clicked.getCheatItemStack()).m_41619_()) {
            CommandUtil.giveStack(itemStack, input, clientConfig);
        }
        return true;
    }

    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.searchField.m_93696_();
    }

    public void clearKeyboardFocus() {
        this.setKeyboardFocus(false);
    }

    private void setKeyboardFocus(boolean keyboardFocus) {
        this.searchField.m_93692_(keyboardFocus);
    }

    public boolean onGlobalKeyPressed(InputConstants.Key input, MouseClickState clickState) {
        if (this.isListDisplayed()) {
            if (KeyBindings.toggleCheatMode.isActiveAndMatches(input)) {
                if (!clickState.isSimulate()) {
                    this.worldConfig.toggleCheatItemsEnabled();
                }
                return true;
            }
            if (KeyBindings.toggleEditMode.isActiveAndMatches(input)) {
                if (!clickState.isSimulate()) {
                    this.worldConfig.toggleEditModeEnabled();
                }
                return true;
            }
            if (KeyBindings.focusSearch.isActiveAndMatches(input)) {
                if (!clickState.isSimulate()) {
                    this.setKeyboardFocus(true);
                }
                return true;
            }
        }
        return false;
    }

    public boolean onCharTyped(char codePoint, int modifiers) {
        if (this.isListDisplayed() && this.hasKeyboardFocus() && this.searchField.m_5534_(codePoint, modifiers)) {
            boolean changed = this.worldConfig.setFilterText(this.searchField.m_94155_());
            if (changed) {
                this.updateLayout(true);
            }
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isListDisplayed()) {
            if (this.hasKeyboardFocus() && this.searchField.m_7933_(keyCode, scanCode, modifiers)) {
                boolean changed = this.worldConfig.setFilterText(this.searchField.m_94155_());
                if (changed) {
                    this.updateLayout(true);
                }
                return true;
            }
            boolean pressed = this.contents.onKeyPressed(keyCode, scanCode, modifiers);
            if (pressed) {
                this.clearKeyboardFocus();
            }
            return pressed;
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getElementUnderMouse(ingredientType).map(IIngredientListElement::getIngredient).orElse(null);
        }
        return null;
    }

    public void onSetFilterText(String filterText) {
        this.searchField.m_94144_(filterText);
        this.updateLayout(true);
    }

    @Override
    public <T> List<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            List<IIngredientListElement<T>> visibleElements = this.contents.getVisibleElements(ingredientType);
            return visibleElements.stream().map(IIngredientListElement::getIngredient).toList();
        }
        return Collections.emptyList();
    }

    private class MouseHandler
    implements IMouseHandler {
        private MouseHandler() {
        }

        @Override
        @Nullable
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            ClickResult clickResult = IngredientListOverlay.this.handleMouseClickedInternal(screen, mouseX, mouseY, mouseButton, clickState);
            if (!clickState.isSimulate()) {
                IngredientListOverlay.this.setKeyboardFocus(clickResult.keyboardFocused);
            }
            if (!clickResult.handled) {
                return null;
            }
            return this;
        }

        @Override
        public void handleMouseClickedOut(int mouseButton) {
            IngredientListOverlay.this.clearKeyboardFocus();
        }

        @Override
        public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            if (!IngredientListOverlay.this.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            IMouseHandler mouseHandler = IngredientListOverlay.this.contents.getMouseHandler();
            return mouseHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta);
        }
    }

    private static class ClickResult {
        public final boolean handled;
        public final boolean keyboardFocused;

        public ClickResult(boolean handled, boolean keyboardFocused) {
            this.handled = handled;
            this.keyboardFocused = keyboardFocused;
        }
    }
}

