/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.bookmarks.BookmarkButton;
import mezz.jei.gui.overlay.bookmarks.ILeftAreaContent;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.click.MouseClickState;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;

public class BookmarkOverlay
implements IShowsRecipeFocuses,
ILeftAreaContent,
IBookmarkOverlay {
    private static final int BUTTON_SIZE = 20;
    private Rect2i parentArea = new Rect2i(0, 0, 0, 0);
    private Rect2i displayArea = new Rect2i(0, 0, 0, 0);
    private final IngredientGridWithNavigation contents;
    private final GuiIconToggleButton bookmarkButton;
    private boolean hasRoom = false;
    private final BookmarkList bookmarkList;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;
    private final IMouseHandler mouseHandler;

    public BookmarkOverlay(BookmarkList bookmarkList, Textures textures, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig) {
        this.bookmarkList = bookmarkList;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.bookmarkButton = BookmarkButton.create(this, bookmarkList, textures, worldConfig);
        this.contents = contents;
        this.mouseHandler = new MouseHandler();
        bookmarkList.addListener(() -> contents.updateLayout(false));
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isBookmarkOverlayEnabled() && this.hasRoom && !this.bookmarkList.isEmpty();
    }

    public boolean hasRoom() {
        return this.hasRoom;
    }

    @Override
    public void updateBounds(Rect2i area, Set<Rect2i> guiExclusionAreas) {
        this.parentArea = area;
        this.hasRoom = this.updateBounds(guiExclusionAreas);
    }

    @Override
    public void drawScreen(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        this.bookmarkButton.draw(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        this.bookmarkButton.drawTooltips(poseStack, mouseX, mouseY);
    }

    private static int getMinWidth() {
        return Math.max(80, 4 * IngredientGrid.INGREDIENT_WIDTH);
    }

    public boolean updateBounds(Set<Rect2i> guiExclusionAreas) {
        this.displayArea = this.parentArea;
        int minWidth = BookmarkOverlay.getMinWidth();
        if (this.displayArea.m_110090_() < minWidth) {
            return false;
        }
        Rect2i availableContentsArea = new Rect2i(this.displayArea.m_110085_(), this.displayArea.m_110086_(), this.displayArea.m_110090_(), this.displayArea.m_110091_() - 24);
        boolean contentsHasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        Rect2i contentsArea = this.contents.getArea();
        this.displayArea = new Rect2i(contentsArea.m_110085_(), this.displayArea.m_110086_(), contentsArea.m_110090_(), this.displayArea.m_110091_());
        this.bookmarkButton.updateBounds(new Rect2i(this.displayArea.m_110085_(), this.displayArea.m_110086_() + this.displayArea.m_110091_() - 20 - 2, 20, 20));
        this.contents.updateLayout(false);
        return contentsHasRoom;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getElementUnderMouse(ingredientType).map(IIngredientListElement::getIngredient).orElse(null);
        }
        return null;
    }

    @Override
    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    private class MouseHandler
    implements IMouseHandler {
        private MouseHandler() {
        }

        @Override
        public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            if (!BookmarkOverlay.this.isListDisplayed()) {
                return false;
            }
            IMouseHandler mouseHandler = BookmarkOverlay.this.contents.getMouseHandler();
            return mouseHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta);
        }

        @Override
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            if (BookmarkOverlay.this.isListDisplayed()) {
                if (MathUtil.contains(BookmarkOverlay.this.displayArea, mouseX, mouseY) && this.handleCheatItemClick(screen, mouseX, mouseY, mouseButton, clickState)) {
                    return this;
                }
                if (BookmarkOverlay.this.contents.isMouseOver(mouseX, mouseY)) {
                    return BookmarkOverlay.this.contents.getMouseHandler().handleClick(screen, mouseX, mouseY, mouseButton, clickState);
                }
            }
            if (BookmarkOverlay.this.bookmarkButton.isMouseOver(mouseX, mouseY)) {
                return BookmarkOverlay.this.bookmarkButton.getMouseHandler().handleClick(screen, mouseX, mouseY, mouseButton, clickState);
            }
            return null;
        }

        private boolean handleCheatItemClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            IClickedIngredient<?> clicked;
            Minecraft minecraft = Minecraft.m_91087_();
            InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(mouseButton);
            if (!(screen instanceof RecipesGui) && (mouseButton == 0 || mouseButton == 1 || minecraft.f_91066_.f_92097_.isActiveAndMatches(input)) && (clicked = BookmarkOverlay.this.getIngredientUnderMouse(mouseX, mouseY)) != null && BookmarkOverlay.this.worldConfig.isCheatItemsEnabled()) {
                ItemStack itemStack;
                if (!clickState.isSimulate() && !(itemStack = clicked.getCheatItemStack()).m_41619_()) {
                    CommandUtil.giveStack(itemStack, input, BookmarkOverlay.this.clientConfig);
                }
                return true;
            }
            return false;
        }
    }
}

