/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import javax.annotation.Nullable;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.gui.screens.Screen;

public class CombinedMouseHandler
implements IMouseHandler {
    private final Int2ObjectMap<IMouseHandler> mousedDown = new Int2ObjectArrayMap();
    private final Iterable<IMouseHandler> mouseHandlers;

    public CombinedMouseHandler(IMouseHandler ... mouseHandlers) {
        this.mouseHandlers = Arrays.asList(mouseHandlers);
    }

    public CombinedMouseHandler(Iterable<IMouseHandler> mouseHandlers) {
        this.mouseHandlers = mouseHandlers;
    }

    @Override
    @Nullable
    public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        if (clickState.isSimulate() || clickState.isVanilla()) {
            this.mousedDown.remove(mouseButton);
            IMouseHandler handled = null;
            for (IMouseHandler mouseHandler : this.mouseHandlers) {
                if (handled == null) {
                    handled = mouseHandler.handleClick(screen, mouseX, mouseY, mouseButton, clickState);
                    continue;
                }
                mouseHandler.handleMouseClickedOut(mouseButton);
            }
            if (handled != null) {
                if (!clickState.isVanilla()) {
                    this.mousedDown.put(mouseButton, handled);
                }
            } else {
                this.handleMouseClickedOut(mouseButton);
            }
            return handled;
        }
        IMouseHandler mouseHandler = (IMouseHandler)this.mousedDown.remove(mouseButton);
        if (mouseHandler == null) {
            return null;
        }
        return mouseHandler.handleClick(screen, mouseX, mouseY, mouseButton, clickState);
    }

    @Override
    public void handleMouseClickedOut(int mouseButton) {
        for (IMouseHandler mouseHandler : this.mouseHandlers) {
            mouseHandler.handleMouseClickedOut(mouseButton);
        }
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        for (IMouseHandler mouseHandler : this.mouseHandlers) {
            if (!mouseHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta)) continue;
            return true;
        }
        return false;
    }
}

