/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;

public class GuiTextFieldFilter
extends EditBox {
    private static final int MAX_HISTORY = 100;
    private static final int maxSearchLength = 128;
    private static final List<String> history = new LinkedList<String>();
    private final HoverChecker hoverChecker;
    private final IIngredientGridSource ingredientSource;
    private final IWorldConfig worldConfig;
    private final IMouseHandler mouseHandler;
    private boolean previousKeyboardRepeatEnabled;
    private final DrawableNineSliceTexture background;
    private boolean isDrawing = false;

    public GuiTextFieldFilter(IIngredientGridSource ingredientSource, IWorldConfig worldConfig) {
        super(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, TextComponent.f_131282_);
        this.worldConfig = worldConfig;
        this.m_94199_(128);
        this.hoverChecker = new HoverChecker();
        this.ingredientSource = ingredientSource;
        this.background = Internal.getTextures().getSearchBackground();
        this.mouseHandler = new MouseHandler();
    }

    public void updateBounds(Rect2i area) {
        this.f_93620_ = area.m_110085_();
        this.f_93621_ = area.m_110086_();
        this.f_93618_ = area.m_110090_();
        this.f_93619_ = area.m_110091_();
        this.hoverChecker.updateBounds(area.m_110086_(), area.m_110086_() + area.m_110091_(), area.m_110085_(), area.m_110085_() + area.m_110090_());
        this.m_94208_(this.m_94207_());
    }

    public void update() {
        List<IIngredientListElement<?>> ingredientList;
        String filterText = this.worldConfig.getFilterText();
        if (!filterText.equals(this.m_94155_())) {
            this.m_94144_(filterText);
        }
        if ((ingredientList = this.ingredientSource.getIngredientList(filterText)).size() == 0) {
            this.m_94202_(-65536);
        } else {
            this.m_94202_(-1);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean handled = super.m_7933_(keyCode, scanCode, modifiers);
        if (!handled && !history.isEmpty()) {
            if (keyCode == 265) {
                String currentText = this.m_94155_();
                int historyIndex = history.indexOf(currentText);
                if (historyIndex < 0) {
                    historyIndex = this.saveHistory() ? history.size() - 1 : history.size();
                }
                if (historyIndex > 0) {
                    String historyString = history.get(historyIndex - 1);
                    this.m_94144_(historyString);
                    handled = true;
                }
            } else if (keyCode == 264) {
                String currentText = this.m_94155_();
                int historyIndex = history.indexOf(currentText);
                if (historyIndex >= 0) {
                    String historyString = historyIndex + 1 < history.size() ? history.get(historyIndex + 1) : "";
                    this.m_94144_(historyString);
                    handled = true;
                }
            } else if (KeyBindings.isEnterKey(keyCode)) {
                this.saveHistory();
            }
        }
        return handled;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public void m_93692_(boolean keyboardFocus) {
        boolean previousFocus = this.m_93696_();
        super.m_93692_(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (keyboardFocus) {
                this.previousKeyboardRepeatEnabled = minecraft.f_91068_.f_90868_;
                minecraft.f_91068_.m_90926_(true);
            } else {
                minecraft.f_91068_.m_90926_(this.previousKeyboardRepeatEnabled);
            }
            this.saveHistory();
        }
    }

    private boolean saveHistory() {
        String text = this.m_94155_();
        if (text.length() > 0) {
            history.remove(text);
            history.add(text);
            if (history.size() > 100) {
                history.remove(0);
            }
            return true;
        }
        return false;
    }

    protected boolean m_94219_() {
        if (this.isDrawing) {
            return false;
        }
        return super.m_94219_();
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.isDrawing = true;
        if (this.m_94213_()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_);
        }
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        this.isDrawing = false;
    }

    private class MouseHandler
    implements IMouseHandler {
        private MouseHandler() {
        }

        @Override
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            if (!GuiTextFieldFilter.this.m_5953_(mouseX, mouseY)) {
                return null;
            }
            if (mouseButton == 1) {
                if (!clickState.isSimulate()) {
                    GuiTextFieldFilter.this.m_94144_("");
                    GuiTextFieldFilter.this.worldConfig.setFilterText("");
                }
                return this;
            }
            if (!clickState.isSimulate()) {
                if (GuiTextFieldFilter.super.m_6375_(mouseX, mouseY, mouseButton)) {
                    return this;
                }
                return null;
            }
            return this;
        }

        @Override
        public void handleMouseClickedOut(int mouseButton) {
            GuiTextFieldFilter.this.m_93692_(false);
        }
    }
}

