/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.jei.JeiInternalPlugin;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IngredientInfoRecipe> {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private static final int lineSpacing = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final JeiInternalPlugin jeiPlugin;
    private final Component localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures, JeiInternalPlugin jeiPlugin) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.jeiPlugin = jeiPlugin;
        this.localizedName = new TranslatableComponent("gui.jei.category.itemInformation");
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.INFORMATION;
    }

    @Override
    public Class<? extends IngredientInfoRecipe> getRecipeClass() {
        return IngredientInfoRecipe.class;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void setIngredients(IngredientInfoRecipe recipe, IIngredients ingredients) {
        this.setIngredientsTyped(recipe, ingredients);
    }

    private <T> void setIngredientsTyped(IngredientInfoRecipe<T> recipe, IIngredients ingredients) {
        IIngredientType<T> ingredientType = recipe.getIngredientType();
        List<List<T>> recipeIngredients = Collections.singletonList(recipe.getIngredients());
        ingredients.setInputLists(ingredientType, recipeIngredients);
        ingredients.setOutputLists(ingredientType, recipeIngredients);
    }

    @Override
    public void draw(IngredientInfoRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        this.drawTyped(poseStack, recipe);
    }

    private <T> void drawTyped(PoseStack poseStack, IngredientInfoRecipe<T> recipe) {
        boolean xPos = false;
        int yPos = this.slotBackground.getHeight() + 4;
        Minecraft minecraft = Minecraft.m_91087_();
        for (FormattedText descriptionLine : recipe.getDescription()) {
            minecraft.f_91062_.m_92877_(poseStack, Language.m_128107_().m_5536_(descriptionLine), (float)xPos, (float)yPos, -16777216);
            Objects.requireNonNull(minecraft.f_91062_);
            yPos += 9 + 2;
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, IngredientInfoRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int xPos = 71;
        guiItemStacks.init(0, true, xPos, 0);
        guiItemStacks.setBackground(0, this.slotBackground);
        guiItemStacks.set(ingredients);
        IIngredientManager ingredientManager = this.jeiPlugin.ingredientManager;
        if (ingredientManager != null) {
            for (IIngredientType<?> type : ingredientManager.getRegisteredIngredientTypes()) {
                IGuiIngredientGroup<?> group = recipeLayout.getIngredientsGroup(type);
                group.init(0, true, xPos + 1, 1);
                group.set(ingredients);
            }
        }
    }
}

