/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.Focus;
import mezz.jei.ingredients.IngredientInformation;
import mezz.jei.recipes.RecipeCategoryData;
import mezz.jei.recipes.RecipeCategoryDataMap;
import mezz.jei.recipes.RecipeMap;
import net.minecraft.resources.ResourceLocation;

public class InternalRecipeManagerPlugin
implements IRecipeManagerPlugin {
    private final ImmutableMultimap<String, ResourceLocation> categoriesForRecipeCatalystKeys;
    private final IIngredientManager ingredientManager;
    private final RecipeCategoryDataMap recipeCategoriesMap;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final Supplier<Stream<IRecipeCategory<?>>> visibleRecipeCategoriesSupplier;

    public InternalRecipeManagerPlugin(ImmutableMultimap<String, ResourceLocation> categoriesForRecipeCatalystKeys, IIngredientManager ingredientManager, RecipeCategoryDataMap recipeCategoriesMap, RecipeMap recipeInputMap, RecipeMap recipeOutputMap, Supplier<Stream<IRecipeCategory<?>>> visibleRecipeCategoriesSupplier) {
        this.categoriesForRecipeCatalystKeys = categoriesForRecipeCatalystKeys;
        this.ingredientManager = ingredientManager;
        this.recipeCategoriesMap = recipeCategoriesMap;
        this.recipeInputMap = recipeInputMap;
        this.recipeOutputMap = recipeOutputMap;
        this.visibleRecipeCategoriesSupplier = visibleRecipeCategoriesSupplier;
    }

    public <V> ImmutableList<ResourceLocation> getRecipeCategoryUids(IFocus<V> focus) {
        focus = Focus.check(focus);
        V ingredient = focus.getValue();
        return switch (focus.getMode()) {
            case IFocus.Mode.INPUT -> this.recipeInputMap.getRecipeCategories(ingredient);
            case IFocus.Mode.OUTPUT -> this.recipeOutputMap.getRecipeCategories(ingredient);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private ImmutableList<ResourceLocation> getRecipeCategories() {
        return (ImmutableList)this.visibleRecipeCategoriesSupplier.get().map(IRecipeCategory::getUid).collect(ImmutableList.toImmutableList());
    }

    public <T, V> ImmutableList<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        focus = Focus.check(focus);
        V ingredient = focus.getValue();
        if (focus.getMode() == IFocus.Mode.INPUT) {
            return this.getInputRecipes(recipeCategory, ingredient);
        }
        return this.recipeOutputMap.getRecipes(recipeCategory, ingredient);
    }

    private <T, V> ImmutableList<T> getInputRecipes(IRecipeCategory<T> recipeCategory, V ingredient) {
        ImmutableList<T> recipes = this.recipeInputMap.getRecipes(recipeCategory, ingredient);
        if (this.isCatalystIngredient(recipeCategory, ingredient)) {
            RecipeCategoryData<T> categoryData = this.recipeCategoriesMap.get(recipeCategory);
            List<T> recipesForCategory = categoryData.getRecipes();
            return (ImmutableList)Stream.concat(recipes.stream(), recipesForCategory.stream()).distinct().collect(ImmutableList.toImmutableList());
        }
        return recipes;
    }

    private <T, V> boolean isCatalystIngredient(IRecipeCategory<T> recipeCategory, V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        ResourceLocation recipeCategoryUid = recipeCategory.getUid();
        List<String> ingredientUids = IngredientInformation.getUniqueIdsWithWildcard(ingredientHelper, ingredient, UidContext.Recipe);
        return ingredientUids.stream().map(arg_0 -> this.categoriesForRecipeCatalystKeys.get(arg_0)).anyMatch(catalystCategories -> catalystCategories.contains((Object)recipeCategoryUid));
    }

    @Override
    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesMap.get(recipeCategory);
        List<T> recipes = recipeCategoryData.getRecipes();
        return Collections.unmodifiableList(recipes);
    }
}

