/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableTable;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.config.Constants;
import mezz.jei.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RecipeTransferManager {
    private final ImmutableTable<Class<?>, ResourceLocation, IRecipeTransferHandler<?, ?>> recipeTransferHandlers;

    public RecipeTransferManager(ImmutableTable<Class<?>, ResourceLocation, IRecipeTransferHandler<?, ?>> recipeTransferHandlers) {
        this.recipeTransferHandlers = recipeTransferHandlers;
    }

    @Nullable
    public <C extends AbstractContainerMenu, R> IRecipeTransferHandler<C, R> getRecipeTransferHandler(C container, IRecipeCategory<R> recipeCategory) {
        ErrorUtil.checkNotNull(container, "container");
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        Class<?> containerClass = container.getClass();
        IRecipeTransferHandler recipeTransferHandler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)recipeCategory.getUid());
        if (recipeTransferHandler != null && recipeTransferHandler.getRecipeClass().isAssignableFrom(recipeCategory.getRecipeClass())) {
            return recipeTransferHandler;
        }
        return (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)Constants.UNIVERSAL_RECIPE_TRANSFER_UID);
    }
}

